/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IFilteringRouter;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.ItemIdentifier;
import net.minecraftforge.common.ForgeDirection;

public class FilteringRouter
extends ServerRouter
implements IFilteringRouter {
    private ForgeDirection side;

    public FilteringRouter(UUID id, int dimension, int xCoord, int yCoord, int zCoord, ForgeDirection dir) {
        super(id, dimension, xCoord, yCoord, zCoord);
        this.side = dir;
    }

    @Override
    public List getRouters() {
        if (LogisticsPipes.DEBUG && ForgeDirection.UNKNOWN.equals((Object)this.side)) {
            throw new UnsupportedOperationException(this.toString());
        }
        if (this.getPipe() instanceof PipeItemsFirewall) {
            return ((PipeItemsFirewall)this.getPipe()).getRouters(this);
        }
        return new ArrayList();
    }

    @Override
    public IFilter getFilter() {
        if (LogisticsPipes.DEBUG && ForgeDirection.UNKNOWN.equals((Object)this.side)) {
            throw new UnsupportedOperationException(this.toString());
        }
        if (this.getPipe() instanceof PipeItemsFirewall) {
            return ((PipeItemsFirewall)this.getPipe()).getFilter(this.getId(), this.getSimpleID());
        }
        return new IFilter(){

            @Override
            public UUID getUUID() {
                return UUID.randomUUID();
            }

            @Override
            public int getSimpleID() {
                return -1;
            }

            @Override
            public boolean isBlocked() {
                return true;
            }

            @Override
            public boolean isFilteredItem(ItemIdentifier item) {
                return false;
            }

            @Override
            public boolean blockProvider() {
                return false;
            }

            @Override
            public boolean blockCrafting() {
                return false;
            }

            @Override
            public boolean blockRouting() {
                return false;
            }

            @Override
            public boolean blockPower() {
                return true;
            }
        };
    }

    @Override
    public boolean isIdforOtherSide(int id) {
        if (this.getPipe() instanceof PipeItemsFirewall) {
            return ((PipeItemsFirewall)this.getPipe()).isIdforOtherSide(id);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean act(BitSet hasBeenProcessed, IRouter.IRAction actor) {
        CoreRoutedPipe pipe;
        boolean hasBeenReset = false;
        if (hasBeenProcessed.get(this.simpleID)) {
            return hasBeenReset;
        }
        hasBeenProcessed.set(this.simpleID);
        if (!ForgeDirection.UNKNOWN.equals((Object)this.side) && (pipe = this.getPipe()) != null) {
            IRouter router = pipe.getRouter();
            if (router == null) throw new RuntimeException("Why is the router null? (" + this.toString() + ")");
            if (!(router instanceof FilteringRouter)) throw new RuntimeException("Why is the router not an FilteringRouter? (" + router.toString() + ")");
            if (!ForgeDirection.UNKNOWN.equals((Object)((FilteringRouter)router).side)) throw new RuntimeException("Why is the FilteringRouter not centered? (" + router.toString() + ")");
            hasBeenReset = router.act(hasBeenProcessed, actor);
        }
        if (!actor.isInteresting(this)) {
            return hasBeenReset;
        }
        if (actor.doTo(this)) {
            hasBeenProcessed.clear();
            hasBeenReset = true;
        }
        for (IRouter r : this._adjacentRouter.keySet()) {
            hasBeenReset = hasBeenReset || r.act(hasBeenProcessed, actor);
        }
        for (IRouter r : this._prevAdjacentRouter.keySet()) {
            hasBeenReset = hasBeenReset || r.act(hasBeenProcessed, actor);
        }
        return hasBeenReset;
    }

    @Override
    public String toString() {
        String higher = super.toString().substring(6);
        StringBuilder string = new StringBuilder("Filtering");
        string.append(higher.substring(0, higher.length() - 1));
        string.append(", ");
        string.append(this.side);
        return string.append("}").toString();
    }

    public ForgeDirection getSide() {
        return this.side;
    }
}

