/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.routing.ILiquidProvider;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.request.LiquidRequestTreeNode;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.LiquidLogisticsPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.utils.FinalPair;
import logisticspipes.utils.IHavePriority;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;

public class RequestTree
extends RequestTreeNode {
    public static final EnumSet defaultRequestFlags = EnumSet.of(ActiveRequestType.Provide, ActiveRequestType.Craft);
    private HashMap _promisetotals;
    private HashMap _promisetotalsliquid;

    public RequestTree(ItemIdentifierStack item, IRequestItems requester, RequestTree parent, EnumSet requestFlags) {
        super(item, requester, parent, requestFlags);
    }

    private int getExistingPromisesFor(FinalPair key) {
        Integer n;
        if (this._promisetotals == null) {
            this._promisetotals = new HashMap();
        }
        if ((n = (Integer)this._promisetotals.get(key)) == null) {
            return 0;
        }
        return n;
    }

    private int getExistingLiquidPromisesFor(FinalPair key) {
        Integer n;
        if (this._promisetotalsliquid == null) {
            this._promisetotalsliquid = new HashMap();
        }
        if ((n = (Integer)this._promisetotalsliquid.get(key)) == null) {
            return 0;
        }
        return n;
    }

    protected int getAllPromissesFor(IProvideItems provider, ItemIdentifier item) {
        FinalPair key = new FinalPair(provider, item);
        return this.getExistingPromisesFor(key);
    }

    protected int getAllPromissesFor(ILiquidProvider provider, LiquidIdentifier liquid) {
        FinalPair key = new FinalPair(provider, liquid);
        return this.getExistingLiquidPromisesFor(key);
    }

    protected LinkedList getExtrasFor(ItemIdentifier item) {
        HashMap extraMap = new HashMap();
        this.checkForExtras(item, extraMap);
        this.removeUsedExtras(item, extraMap);
        LinkedList extras = new LinkedList();
        for (List sublist : extraMap.values()) {
            extras.addAll(sublist);
        }
        return extras;
    }

    protected void fullFillAll() {
        this.fullFill();
    }

    public void sendMissingMessage(RequestLog log) {
        HashMap missing = new HashMap();
        this.buildMissingMap(missing);
        log.handleMissingItems(missing);
    }

    public void sendUsedMessage(RequestLog log) {
        HashMap used = new HashMap();
        HashMap missing = new HashMap();
        this.buildUsedMap(used, missing);
        log.handleSucessfullRequestOfList(used);
        log.handleMissingItems(missing);
    }

    protected void promiseAdded(LogisticsPromise promise) {
        FinalPair key = new FinalPair(promise.sender, promise.item);
        this._promisetotals.put(key, this.getExistingPromisesFor(key) + promise.numberOfItems);
    }

    protected void promiseRemoved(LogisticsPromise promise) {
        FinalPair key = new FinalPair(promise.sender, promise.item);
        int r = this.getExistingPromisesFor(key) - promise.numberOfItems;
        if (r == 0) {
            this._promisetotals.remove(key);
        } else {
            this._promisetotals.put(key, r);
        }
    }

    protected void promiseAdded(LiquidLogisticsPromise promise) {
        FinalPair key = new FinalPair(promise.sender, promise.liquid);
        this._promisetotalsliquid.put(key, this.getExistingLiquidPromisesFor(key) + promise.amount);
    }

    protected void promiseRemoved(LiquidLogisticsPromise promise) {
        FinalPair key = new FinalPair(promise.sender, promise.liquid);
        int r = this.getExistingLiquidPromisesFor(key) - promise.amount;
        if (r == 0) {
            this._promisetotalsliquid.remove(key);
        } else {
            this._promisetotalsliquid.put(key, r);
        }
    }

    public static boolean request(List items, IRequestItems requester, RequestLog log, EnumSet requestFlags) {
        HashMap<ItemIdentifier, Integer> messages = new HashMap<ItemIdentifier, Integer>();
        RequestTree tree = new RequestTree(new ItemIdentifierStack(ItemIdentifier.get(1, 0, null), 0), requester, null, requestFlags);
        boolean isDone = true;
        for (ItemIdentifierStack stack : items) {
            ItemIdentifier item = stack.getItem();
            Integer count = (Integer)messages.get(item);
            if (count == null) {
                count = 0;
            }
            count = count + stack.stackSize;
            messages.put(item, count);
            RequestTree node = new RequestTree(stack, requester, tree, requestFlags);
            isDone = isDone && node.isDone();
        }
        if (isDone) {
            tree.fullFillAll();
            if (log != null) {
                log.handleSucessfullRequestOfList(messages);
            }
            return true;
        }
        if (log != null) {
            tree.logFailedRequestTree(log);
        }
        return false;
    }

    public static int request(ItemIdentifierStack item, IRequestItems requester, RequestLog log, boolean acceptPartial, boolean simulateOnly, boolean logMissing, boolean logUsed, EnumSet requestFlags) {
        RequestTree tree = new RequestTree(item, requester, null, requestFlags);
        if (!simulateOnly && (tree.isDone() || tree.getPromiseItemCount() > 0 && acceptPartial)) {
            tree.fullFillAll();
            if (log != null) {
                log.handleSucessfullRequestOf(item.getItem(), item.stackSize);
            }
            return tree.getPromiseItemCount();
        }
        if (log != null) {
            if (!tree.isDone()) {
                tree.recurseFailedRequestTree();
            }
            if (logMissing) {
                tree.sendMissingMessage(log);
            }
            if (logUsed) {
                tree.sendUsedMessage(log);
            }
        }
        return tree.getPromiseItemCount();
    }

    public static int request(ItemIdentifierStack item, IRequestItems requester, RequestLog log) {
        return RequestTree.request(item, requester, log, false, false, true, false, defaultRequestFlags);
    }

    public static int requestPartial(ItemIdentifierStack item, IRequestItems requester) {
        return RequestTree.request(item, requester, null, true, false, true, false, defaultRequestFlags);
    }

    public static int simulate(ItemIdentifierStack item, IRequestItems requester, RequestLog log) {
        return RequestTree.request(item, requester, log, true, true, false, true, defaultRequestFlags);
    }

    public static int requestLiquidPartial(LiquidIdentifier liquid, int amount, IRequestLiquid pipe, RequestLog log) {
        return RequestTree.requestLiquid(liquid, amount, pipe, log, true);
    }

    public static int requestLiquid(LiquidIdentifier liquid, int amount, IRequestLiquid pipe, RequestLog log) {
        return RequestTree.requestLiquid(liquid, amount, pipe, log, false);
    }

    public static int requestLiquid(LiquidIdentifier liquid, int amount, IRequestLiquid pipe, RequestLog log, boolean acceptPartial) {
        LiquidRequestTreeNode request = new LiquidRequestTreeNode(liquid, amount, pipe, null);
        if (request.isDone() || acceptPartial) {
            request.fullFill();
            if (log != null) {
                log.handleSucessfullRequestOf(request.getLiquid().getItemIdentifier(), request.getAmount());
            }
            return request.getPromiseLiquidAmount();
        }
        if (log != null) {
            request.sendMissingMessage(log);
        }
        return request.getPromiseLiquidAmount();
    }

    public static class workWeightedSorter
    implements Comparator {
        public final double distanceWeight;

        public workWeightedSorter(double distanceWeight) {
            this.distanceWeight = distanceWeight;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int compare(ExitRoute o1, ExitRoute o2) {
            double c = 0.0;
            if (o1.destination.getPipe() instanceof IHavePriority) {
                if (!(o2.destination.getPipe() instanceof IHavePriority)) return -1;
                c = ((IHavePriority)((Object)o2.destination.getCachedPipe())).getPriority() - ((IHavePriority)((Object)o1.destination.getCachedPipe())).getPriority();
            } else if (o2.destination.getPipe() instanceof IHavePriority) {
                return 1;
            }
            if (c != 0.0) {
                return (int)c;
            }
            int flip = 1;
            if (o1.destination.getSimpleID() - o2.destination.getSimpleID() < 0) {
                flip = -1;
                ExitRoute o_temp = o1;
                o1 = o2;
                o2 = o_temp;
            }
            c = o1.destination.getCachedPipe().getLoadFactor() - o2.destination.getCachedPipe().getLoadFactor();
            if (this.distanceWeight != 0.0) {
                c += (double)(o1.distanceToDestination - o2.distanceToDestination) * this.distanceWeight;
            }
            if (c == 0.0) {
                return -flip;
            }
            if (!(c > 0.0)) return (int)(c - 0.5) * flip;
            return (int)(c + 0.5) * flip;
        }
    }

    public static enum ActiveRequestType {
        Provide,
        Craft,
        AcceptPartial,
        SimulateOnly,
        LogMissing,
        LogUsed;

    }
}

