/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.orderer.ComponentList;
import logisticspipes.network.packets.orderer.MissingItems;
import logisticspipes.network.packets.orderer.OrdererContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RequestHandler {
    public static void request(final EntityPlayer player, ItemIdentifierStack stack, CoreRoutedPipe pipe) {
        if (!pipe.useEnergy(5)) {
            player.func_70006_a("No Energy");
            return;
        }
        RequestTree.request(ItemIdentifier.get(stack.getItem().itemID, stack.getItem().itemDamage, stack.getItem().tag).makeStack(stack.stackSize), pipe, new RequestLog(){

            @Override
            public void handleMissingItems(Map items) {
                ArrayList<ItemIdentifierStack> coll = new ArrayList<ItemIdentifierStack>(items.size());
                for (Map.Entry e : items.entrySet()) {
                    coll.add(new ItemIdentifierStack((ItemIdentifier)e.getKey(), (Integer)e.getValue()));
                }
                MainProxy.sendPacketToPlayer(((MissingItems)PacketHandler.getPacket(MissingItems.class)).setItems(coll).setFlag(true), (Player)player);
            }

            @Override
            public void handleSucessfullRequestOf(ItemIdentifier item, int count) {
                ArrayList<ItemIdentifierStack> coll = new ArrayList<ItemIdentifierStack>(1);
                coll.add(new ItemIdentifierStack(item, count));
                MainProxy.sendPacketToPlayer(((MissingItems)PacketHandler.getPacket(MissingItems.class)).setItems(coll).setFlag(false), (Player)player);
            }

            @Override
            public void handleSucessfullRequestOfList(Map items) {
            }
        });
    }

    public static void simulate(EntityPlayer player, ItemIdentifierStack stack, CoreRoutedPipe pipe) {
        final HashMap used = new HashMap();
        final HashMap missing = new HashMap();
        RequestTree.simulate(ItemIdentifier.get(stack.getItem().itemID, stack.getItem().itemDamage, stack.getItem().tag).makeStack(stack.stackSize), pipe, new RequestLog(){

            @Override
            public void handleMissingItems(Map items) {
                for (Map.Entry e : items.entrySet()) {
                    Integer count = (Integer)missing.get(e.getKey());
                    if (count == null) {
                        count = 0;
                    }
                    count = count + (Integer)e.getValue();
                    missing.put(e.getKey(), count);
                }
            }

            @Override
            public void handleSucessfullRequestOf(ItemIdentifier item, int count) {
            }

            @Override
            public void handleSucessfullRequestOfList(Map items) {
                for (Map.Entry e : items.entrySet()) {
                    Integer count = (Integer)used.get(e.getKey());
                    if (count == null) {
                        count = 0;
                    }
                    count = count + (Integer)e.getValue();
                    used.put(e.getKey(), count);
                }
            }
        });
        ArrayList<ItemIdentifierStack> usedList = new ArrayList<ItemIdentifierStack>(used.size());
        ArrayList<ItemIdentifierStack> missingList = new ArrayList<ItemIdentifierStack>(missing.size());
        for (Map.Entry e : used.entrySet()) {
            usedList.add(new ItemIdentifierStack((ItemIdentifier)e.getKey(), (Integer)e.getValue()));
        }
        for (Map.Entry e : missing.entrySet()) {
            missingList.add(new ItemIdentifierStack((ItemIdentifier)e.getKey(), (Integer)e.getValue()));
        }
        MainProxy.sendPacketToPlayer(((ComponentList)PacketHandler.getPacket(ComponentList.class)).setUsed(usedList).setMissing(missingList), (Player)player);
    }

    public static void refresh(EntityPlayer player, CoreRoutedPipe pipe, DisplayOptions option) {
        HashMap _availableItems = option == DisplayOptions.SupplyOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getAvailableItems(pipe.getRouter().getIRoutersByCost()) : new HashMap();
        LinkedList _craftableItems = option == DisplayOptions.CraftOnly || option == DisplayOptions.Both ? SimpleServiceLocator.logisticsManager.getCraftableItems(pipe.getRouter().getIRoutersByCost()) : new LinkedList();
        TreeSet<ItemIdentifierStack> _allItems = new TreeSet<ItemIdentifierStack>();
        for (Map.Entry entry : _availableItems.entrySet()) {
            ItemIdentifierStack newStack = ((ItemIdentifier)entry.getKey()).makeStack((Integer)entry.getValue());
            _allItems.add(newStack);
        }
        for (ItemIdentifier itemIdentifier : _craftableItems) {
            if (_availableItems.containsKey(itemIdentifier)) continue;
            _allItems.add(itemIdentifier.makeStack(0));
        }
        MainProxy.sendPacketToPlayer(((OrdererContent)PacketHandler.getPacket(OrdererContent.class)).setIdentSet(_allItems), (Player)player);
    }

    public static void requestMacrolist(NBTTagCompound itemlist, CoreRoutedPipe requester, final EntityPlayer player) {
        if (!requester.useEnergy(5)) {
            player.func_70006_a("No Energy");
            return;
        }
        NBTTagList list = itemlist.func_74761_m("inventar");
        ArrayList<ItemIdentifierStack> transaction = new ArrayList<ItemIdentifierStack>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemnbt = (NBTTagCompound)list.func_74743_b(i);
            NBTTagCompound itemNBTContent = itemnbt.func_74775_l("nbt");
            if (!itemnbt.func_74764_b("nbt")) {
                itemNBTContent = null;
            }
            ItemIdentifierStack stack = ItemIdentifier.get(itemnbt.func_74762_e("id"), itemnbt.func_74762_e("data"), itemNBTContent).makeStack(itemnbt.func_74762_e("amount"));
            transaction.add(stack);
        }
        RequestTree.request(transaction, requester, new RequestLog(){

            @Override
            public void handleMissingItems(Map items) {
                ArrayList<ItemIdentifierStack> coll = new ArrayList<ItemIdentifierStack>(items.size());
                for (Map.Entry e : items.entrySet()) {
                    coll.add(new ItemIdentifierStack((ItemIdentifier)e.getKey(), (Integer)e.getValue()));
                }
                MainProxy.sendPacketToPlayer(((MissingItems)PacketHandler.getPacket(MissingItems.class)).setItems(coll).setFlag(true), (Player)player);
            }

            @Override
            public void handleSucessfullRequestOf(ItemIdentifier item, int count) {
            }

            @Override
            public void handleSucessfullRequestOfList(Map items) {
                ArrayList<ItemIdentifierStack> coll = new ArrayList<ItemIdentifierStack>(items.size());
                for (Map.Entry e : items.entrySet()) {
                    coll.add(new ItemIdentifierStack((ItemIdentifier)e.getKey(), (Integer)e.getValue()));
                }
                MainProxy.sendPacketToPlayer(((MissingItems)PacketHandler.getPacket(MissingItems.class)).setItems(coll).setFlag(false), (Player)player);
            }
        }, RequestTree.defaultRequestFlags);
    }

    public static Object[] computerRequest(ItemIdentifierStack makeStack, CoreRoutedPipe pipe, boolean craftingOnly) {
        EnumSet<RequestTree.ActiveRequestType> requestFlags = craftingOnly ? EnumSet.of(RequestTree.ActiveRequestType.Craft) : EnumSet.of(RequestTree.ActiveRequestType.Craft, RequestTree.ActiveRequestType.Provide);
        if (!pipe.useEnergy(15)) {
            return new Object[]{"NO_POWER"};
        }
        final Object[] status = new String[2];
        RequestTree.request(makeStack, pipe, new RequestLog(){

            @Override
            public void handleMissingItems(Map items) {
                status[0] = "MISSING";
                LinkedList<Pair> itemList = new LinkedList<Pair>();
                for (Map.Entry item : items.entrySet()) {
                    itemList.add(new Pair(item.getKey(), item.getValue()));
                }
                status[1] = itemList;
            }

            @Override
            public void handleSucessfullRequestOf(ItemIdentifier item, int count) {
                status[0] = "DONE";
                LinkedList<Pair> itemList = new LinkedList<Pair>();
                itemList.add(new Pair(item, count));
                status[1] = itemList;
            }

            @Override
            public void handleSucessfullRequestOfList(Map items) {
            }
        }, false, false, true, false, requestFlags);
        return status;
    }

    public static void refreshLiquid(EntityPlayer player, CoreRoutedPipe pipe) {
        TreeSet _allItems = SimpleServiceLocator.logisticsLiquidManager.getAvailableLiquid(pipe.getRouter().getIRoutersByCost());
        MainProxy.sendPacketToPlayer(((OrdererContent)PacketHandler.getPacket(OrdererContent.class)).setIdentSet(_allItems), (Player)player);
    }

    public static void requestLiquid(final EntityPlayer player, ItemIdentifierStack stack, CoreRoutedPipe pipe, IRequestLiquid requester) {
        if (!pipe.useEnergy(10)) {
            player.func_70006_a("No Energy");
            return;
        }
        RequestTree.requestLiquid(LiquidIdentifier.get(stack.getItem().itemID, stack.getItem().itemDamage), stack.stackSize, requester, new RequestLog(){

            @Override
            public void handleMissingItems(Map items) {
                ArrayList<ItemIdentifierStack> coll = new ArrayList<ItemIdentifierStack>(items.size());
                for (Map.Entry e : items.entrySet()) {
                    coll.add(new ItemIdentifierStack((ItemIdentifier)e.getKey(), (Integer)e.getValue()));
                }
                MainProxy.sendPacketToPlayer(((MissingItems)PacketHandler.getPacket(MissingItems.class)).setItems(coll).setFlag(true), (Player)player);
            }

            @Override
            public void handleSucessfullRequestOf(ItemIdentifier item, int count) {
                ArrayList<ItemIdentifierStack> coll = new ArrayList<ItemIdentifierStack>(1);
                coll.add(new ItemIdentifierStack(item, count));
                MainProxy.sendPacketToPlayer(((MissingItems)PacketHandler.getPacket(MissingItems.class)).setItems(coll).setFlag(false), (Player)player);
            }

            @Override
            public void handleSucessfullRequestOfList(Map items) {
            }
        });
    }

    public static enum DisplayOptions {
        Both,
        SupplyOnly,
        CraftOnly;

    }
}

