/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.routing.ILiquidProvider;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.liquid.LiquidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LiquidLogisticsPromise;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;

public class LiquidRequestTreeNode {
    protected final LiquidIdentifier liquid;
    protected final int amount;
    protected List promises = new ArrayList();
    private int promiseLiquidAmount = 0;
    protected final RequestTree root;
    protected final IRequestLiquid target;
    private final RequestTreeNode parentNode;

    public LiquidRequestTreeNode(LiquidIdentifier liquid, int amount, IRequestLiquid target, RequestTreeNode parentNode) {
        this.liquid = liquid;
        this.amount = amount;
        this.target = target;
        this.parentNode = parentNode;
        if (parentNode != null) {
            parentNode.liquidSubRequests.add(this);
            this.root = parentNode.root;
        } else {
            this.root = null;
        }
        this.checkLiquidProvider();
    }

    public void addPromise(LiquidLogisticsPromise promise) {
        this.promises.add(promise);
        this.promiseLiquidAmount += promise.amount;
        if (this.root != null) {
            this.root.promiseAdded(promise);
        }
    }

    protected void buildMissingMap(Map missing) {
        if (this.amountLeft() != 0) {
            ItemIdentifier item = this.liquid.getItemIdentifier();
            Integer count = (Integer)missing.get(item);
            if (count == null) {
                count = 0;
            }
            count = count + this.amountLeft();
            missing.put(item, count);
        }
    }

    public void fullFill() {
        for (LiquidLogisticsPromise promise : this.promises) {
            promise.sender.fullFill(promise, this.target);
        }
    }

    public IRequestLiquid getTarget() {
        return this.target;
    }

    void destroy() {
        if (this.parentNode != null) {
            this.parentNode.remove(this);
        }
    }

    protected void removeSubPromisses() {
        for (LiquidLogisticsPromise promise : this.promises) {
            if (this.root == null) continue;
            this.root.promiseRemoved(promise);
        }
    }

    private boolean checkLiquidProvider() {
        boolean done = true;
        LiquidRoutedPipe thisPipe = (LiquidRoutedPipe)((Object)this.target);
        List providers = this.getLiquidProviders();
        for (ILiquidProvider provider : providers) {
            if (thisPipe.sharesTankWith((LiquidRoutedPipe)((Object)provider))) continue;
            int alreadyRequested = 0;
            if (this.root != null) {
                alreadyRequested = this.root.getAllPromissesFor(provider, this.getLiquid());
            }
            provider.canProvide(this, alreadyRequested);
        }
        if (!this.isDone()) {
            done = false;
        }
        return done;
    }

    private List getLiquidProviders() {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(this.liquid.getItemIdentifier());
        LinkedList<ILiquidProvider> providers = new LinkedList<ILiquidProvider>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            CoreRoutedPipe pipe;
            ExitRoute e;
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            if (r.getPipe() instanceof ILiquidProvider && (e = this.target.getRouter().getDistanceTo(r)) != null && (pipe = e.destination.getPipe()) instanceof ILiquidProvider) {
                providers.add((ILiquidProvider)((Object)pipe));
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        return providers;
    }

    public int getAmount() {
        return this.amount;
    }

    public LiquidIdentifier getLiquid() {
        return this.liquid;
    }

    public ItemIdentifierStack getStack() {
        return this.liquid.getItemIdentifier().makeStack(this.amount);
    }

    public int amountLeft() {
        return this.amount - this.promiseLiquidAmount;
    }

    public boolean isDone() {
        return this.amountLeft() <= 0;
    }

    public void sendMissingMessage(RequestLog log) {
        HashMap<ItemIdentifier, Integer> missing = new HashMap<ItemIdentifier, Integer>();
        missing.put(this.liquid.getItemIdentifier(), this.amountLeft());
        log.handleMissingItems(missing);
    }

    public int getPromiseLiquidAmount() {
        return this.promiseLiquidAmount;
    }
}

