/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import buildcraft.BuildCraftCore;
import buildcraft.core.render.RenderEntityBlock;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.render.RenderPipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import logisticspipes.logic.BaseLogicCrafting;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelSign;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class LogisticsRenderPipe
extends RenderPipe {
    private static final int LIQUID_STAGES = 40;
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private HashMap displayLiquidLists = new HashMap();
    private ModelSign modelSign = new ModelSign();
    private RenderBlocks renderBlocks = new RenderBlocks();

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        super.func_76894_a(tileentity, x, y, z, f);
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe.transport instanceof PipeLiquidTransportLogistics) {
            this.renderLiquids(pipe.pipe, x, y, z);
        }
        if (pipe.pipe instanceof PipeItemsCraftingLogistics) {
            this.renderCraftingPipe((PipeItemsCraftingLogistics)pipe.pipe, x, y, z);
        }
        if (pipe.pipe instanceof PipeBlockRequestTable) {
            try {
                this.renderBlock((PipeBlockRequestTable)pipe.pipe, x, y, z);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void renderBlock(PipeBlockRequestTable blockPipe, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glPopMatrix();
    }

    private boolean needDistance(List list) {
        boolean result;
        ArrayList copy = new ArrayList(list);
        copy.remove(ForgeDirection.UP);
        copy.remove(ForgeDirection.DOWN);
        copy.remove(ForgeDirection.UNKNOWN);
        boolean bl = result = copy.size() > 1;
        if (copy.size() == 2) {
            if (copy.contains(ForgeDirection.NORTH) && copy.contains(ForgeDirection.SOUTH)) {
                result = false;
            }
            if (copy.contains(ForgeDirection.EAST) && copy.contains(ForgeDirection.WEST)) {
                result = false;
            }
        }
        return result;
    }

    private void renderCraftingPipe(PipeItemsCraftingLogistics pipe, double x, double y, double z) {
        if (!pipe.getCraftingSigns().isEmpty()) {
            List list = pipe.getCraftingSigns();
            for (ForgeDirection dir : list) {
                if (pipe.container.getRenderState().pipeConnectionMatrix.isConnected(dir)) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                switch (dir) {
                    case UP: {
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case DOWN: {
                        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case NORTH: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case SOUTH: {
                        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case EAST: {
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case WEST: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                }
                this.renderSign(pipe);
                GL11.glPopMatrix();
            }
        }
    }

    private void renderSign(PipeItemsCraftingLogistics pipe) {
        float var10 = 0.6666667f;
        float var12 = 0.016666668f * var10;
        GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.31f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.modelSign.field_78165_b.field_78806_j = false;
        this.func_76897_a("/item/sign.png");
        GL11.glPushMatrix();
        GL11.glScalef((float)var10, (float)(-var10), (float)(-var10));
        this.modelSign.func_78164_a();
        GL11.glPopMatrix();
        GL11.glTranslatef((float)-0.32f, (float)(0.5f * var10 + 0.08f), (float)(0.07f * var10));
        GL11.glPushAttrib((int)1048575);
        this.renderSignLabel(pipe, var12);
        GL11.glPopAttrib();
    }

    private void renderSignLabel(PipeItemsCraftingLogistics pipe, float var12) {
        FontRenderer var17 = this.func_76895_b();
        if (pipe != null) {
            List craftables = ((BaseLogicCrafting)pipe.logic).getCraftedItems();
            String name = "";
            if (craftables != null && craftables.size() > 0) {
                ItemStack itemstack = (ItemStack)craftables.get(0);
                if (itemstack == null || itemstack.func_77973_b() == null) {
                    return;
                }
                Item item = itemstack.func_77973_b();
                IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
                this.func_76897_a(itemstack.func_94608_d() == 0 ? "/terrain.png" : "/gui/items.png");
                GL11.glPushMatrix();
                if (customRenderer != null) {
                    if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.INVENTORY, itemstack, IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK)) {
                        GL11.glScalef((float)0.2f, (float)-0.2f, (float)-0.01f);
                        GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glDisable((int)2896);
                        GL11.glDisable((int)16384);
                        GL11.glDisable((int)16385);
                        GL11.glDisable((int)2903);
                        customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, itemstack, new Object[]{this.renderBlocks});
                        GL11.glEnable((int)2896);
                        GL11.glEnable((int)16384);
                        GL11.glEnable((int)16385);
                        GL11.glEnable((int)2903);
                    } else {
                        GL11.glScalef((float)0.018f, (float)-0.018f, (float)-0.01f);
                        GL11.glTranslatef((float)-7.0f, (float)-8.0f, (float)0.0f);
                        GL11.glDisable((int)2896);
                        GL11.glDisable((int)16384);
                        GL11.glDisable((int)16385);
                        GL11.glDisable((int)2903);
                        customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, itemstack, new Object[]{this.renderBlocks});
                        GL11.glEnable((int)2896);
                        GL11.glEnable((int)16384);
                        GL11.glEnable((int)16385);
                        GL11.glEnable((int)2903);
                    }
                } else if (item instanceof ItemBlock && RenderBlocks.func_78597_b((int)Block.field_71973_m[item.field_77779_bT].func_71857_b())) {
                    GL11.glScalef((float)0.2f, (float)-0.2f, (float)-0.01f);
                    GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.renderBlocks.field_78668_c = false;
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)16384);
                    GL11.glDisable((int)16385);
                    GL11.glDisable((int)2903);
                    this.renderBlocks.func_78600_a(Block.field_71973_m[item.field_77779_bT], itemstack.func_77960_j(), 1.0f);
                    GL11.glEnable((int)2896);
                    GL11.glEnable((int)16384);
                    GL11.glEnable((int)16385);
                    GL11.glEnable((int)2903);
                } else {
                    GL11.glScalef((float)0.02f, (float)-0.02f, (float)-0.01f);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)16384);
                    GL11.glDisable((int)16385);
                    GL11.glDisable((int)2903);
                    GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)0.0f);
                    if (item.func_77623_v()) {
                        for (int var14 = 0; var14 < item.getRenderPasses(itemstack.func_77960_j()); ++var14) {
                            Icon var15 = item.func_77618_c(itemstack.func_77960_j(), var14);
                            this.renderItem(var15);
                        }
                    } else {
                        this.renderItem(item.func_77650_f(itemstack));
                    }
                    GL11.glEnable((int)2896);
                    GL11.glEnable((int)16384);
                    GL11.glEnable((int)16385);
                    GL11.glEnable((int)2903);
                }
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)false);
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)var12, (float)var12, (float)var12);
                try {
                    name = item.func_77628_j(itemstack);
                }
                catch (Exception e) {
                    try {
                        name = item.func_77658_a();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                var17.func_78276_b("ID: " + String.valueOf(item.field_77779_bT), -var17.func_78256_a("ID: " + String.valueOf(item.field_77779_bT)) / 2, -20, 0);
                if (((BaseLogicCrafting)pipe.logic).satelliteId != 0) {
                    var17.func_78276_b("Sat ID: " + String.valueOf(((BaseLogicCrafting)pipe.logic).satelliteId), -var17.func_78256_a("Sat ID: " + String.valueOf(((BaseLogicCrafting)pipe.logic).satelliteId)) / 2, -10, 0);
                }
            } else {
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)var12, (float)var12, (float)var12);
                name = "Empty";
            }
            name = this.cut(name, var17);
            var17.func_78276_b(name, -var17.func_78256_a(name) / 2 - 15, 10, 0);
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderItem(Icon par3Icon) {
        if (par3Icon == null) {
            return;
        }
        int par1 = 0;
        int par2 = 0;
        int par4 = 16;
        int par5 = 16;
        double zLevel = 0.0;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), zLevel, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), zLevel, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), zLevel, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), zLevel, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    private String cut(String name, FontRenderer renderer) {
        if (renderer.func_78256_a(name) < 90) {
            return name;
        }
        StringBuilder sum = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (renderer.func_78256_a(sum.toString() + name.charAt(i) + "...") >= 90) {
                return sum.toString() + "...";
            }
            sum.append(name.charAt(i));
        }
        return sum.toString();
    }

    private void renderLiquids(Pipe pipe, double x, double y, double z) {
        DisplayLiquidList d;
        PipeLiquidTransportLogistics liq = (PipeLiquidTransportLogistics)pipe.transport;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayLiquidList d2;
            LiquidStack liquid = liq.renderCache[i];
            if (liquid == null || liquid.amount <= 0 || (d2 = this.getListFromBuffer(liquid, pipe.worldObj)) == null) continue;
            int stage = (int)((float)liquid.amount / (float)liq.getSideCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.func_76897_a(liquid.canonical().getTextureSheet());
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        LiquidStack liquid = liq.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (liquid != null && liquid.amount > 0 && (d = this.getListFromBuffer(liquid, pipe.worldObj)) != null) {
            int stage = (int)((float)liquid.amount / (float)liq.getInnerCapacity() * 39.0f);
            this.func_76897_a(liquid.canonical().getTextureSheet());
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private DisplayLiquidList getListFromBuffer(LiquidStack stack, World world) {
        int liquidId = stack.itemID;
        if (liquidId == 0) {
            return null;
        }
        return this.getDisplayLiquidLists(liquidId, stack.itemMeta, world);
    }

    private DisplayLiquidList getDisplayLiquidLists(int liquidId, int meta, World world) {
        if (this.displayLiquidLists.containsKey(liquidId)) {
            HashMap x = (HashMap)this.displayLiquidLists.get(liquidId);
            if (x.containsKey(meta)) {
                return (DisplayLiquidList)x.get(meta);
            }
        } else {
            this.displayLiquidLists.put(liquidId, new HashMap());
        }
        DisplayLiquidList d = new DisplayLiquidList();
        ((HashMap)this.displayLiquidLists.get(liquidId)).put(meta, d);
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        if (liquidId < Block.field_71973_m.length && Block.field_71973_m[liquidId] != null) {
            block.baseBlock = Block.field_71973_m[liquidId];
        } else {
            block.baseBlock = Block.field_71943_B;
            block.texture = Item.field_77698_e[liquidId].func_77617_a(meta);
        }
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (IBlockAccess)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (IBlockAccess)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (IBlockAccess)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (IBlockAccess)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
        }
        return d;
    }

    private class DisplayLiquidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayLiquidList() {
        }
    }
}

