/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import logisticspipes.items.LogisticsItemCard;
import logisticspipes.items.LogisticsLiquidContainer;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.Colors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LiquidContainerRenderer
implements IItemRenderer {
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private boolean useThis = true;
    private RenderItem renderItem;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (this.useThis && item != null) {
            if (item.func_77973_b() instanceof LogisticsLiquidContainer) {
                switch (type) {
                    case ENTITY: {
                        return true;
                    }
                    case INVENTORY: {
                        return true;
                    }
                }
                return false;
            }
            if (item.func_77973_b() instanceof LogisticsItemCard) {
                switch (type) {
                    case INVENTORY: {
                        return Keyboard.isKeyDown((int)42);
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (item.func_77973_b() instanceof LogisticsLiquidContainer) {
            LiquidStack liquid = SimpleServiceLocator.logisticsLiquidManager.getLiquidFromContainer(item);
            if (liquid == null) {
                this.doRenderItem(item, mc, type, data);
                GL11.glPopMatrix();
                return;
            }
            ItemStack liquidItem = liquid.asItemStack();
            GL11.glPushMatrix();
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glScaled((double)0.45, (double)0.75, (double)1.0);
                GL11.glTranslated((double)10.0, (double)2.5, (double)0.0);
            } else {
                GL11.glScaled((double)0.45, (double)0.75, (double)0.45);
                GL11.glTranslated((double)0.0, (double)0.09, (double)0.0);
            }
            this.doRenderItem(liquidItem, mc, type, data);
            GL11.glPopMatrix();
            this.doRenderItem(item, mc, type, data);
        } else if (item.func_77973_b() instanceof LogisticsItemCard) {
            this.doRenderItem(item, mc, type, data);
            NBTTagCompound nbt = item.func_77978_p();
            if (nbt == null || !nbt.func_74764_b("colors")) {
                GL11.glPopMatrix();
                return;
            }
            NBTTagCompound colors = nbt.func_74775_l("colors");
            if (colors == null) {
                GL11.glPopMatrix();
                return;
            }
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glScaled((double)0.07, (double)0.07, (double)1.0);
                GL11.glTranslated((double)-3.0, (double)3.5, (double)-0.025);
            }
            for (int i = 0; i < 6; ++i) {
                int colorCode = colors.func_74762_e("color:" + i);
                Colors color = Colors.values()[colorCode];
                int x = i / 3;
                int y = i % 3;
                if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                    this.drawRect(x * 5 + 4, y * 3 + 3, x * 5 + 7, y * 3 + 5, color.getColorCode());
                }
                if (type != IItemRenderer.ItemRenderType.ENTITY) continue;
                this.drawRect(-x * 5 + 4, -y * 3 + 3, -x * 5 + 7, -y * 3 + 5, color.getColorCode());
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                this.drawRect(-x * 5 + 4, -y * 3 + 3, -x * 5 + 7, -y * 3 + 5, color.getColorCode());
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GL11.glPopMatrix();
    }

    public void doRenderItem(ItemStack itemstack, Minecraft mc, IItemRenderer.ItemRenderType type, Object[] data) {
        this.useThis = false;
        if (this.renderItem == null) {
            this.renderItem = new RenderItem(){

                public boolean shouldBob() {
                    return false;
                }

                public boolean shouldSpreadItems() {
                    return false;
                }
            };
            this.renderItem.func_76976_a(RenderManager.field_78727_a);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderItem.func_82406_b(mc.field_71466_p, mc.field_71446_o, itemstack, 0, 0);
        } else {
            GL11.glPushMatrix();
            this.dummyEntityItem.func_92058_a(itemstack);
            this.dummyEntityItem.field_70290_d = 0.0f;
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GL11.glRotatef((float)(((float)((EntityItem)data[1]).field_70292_b / 20.0f + ((EntityItem)data[1]).field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderItem.func_77014_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
        this.useThis = true;
    }

    private void drawRect(int par0, int par1, int par2, int par3, int par4) {
        int j1;
        if (par0 < par2) {
            j1 = par0;
            par0 = par2;
            par2 = j1;
        }
        if (par1 < par3) {
            j1 = par1;
            par1 = par3;
            par3 = j1;
        }
        float f = (float)(par4 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par4 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par4 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par4 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)par0, (double)par3, 0.0);
        tessellator.func_78377_a((double)par2, (double)par3, 0.0);
        tessellator.func_78377_a((double)par2, (double)par1, 0.0);
        tessellator.func_78377_a((double)par0, (double)par1, 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }
}

