/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialtankhandler;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.com.google.common.collect.Lists;
import logisticspipes.interfaces.ISpecialTankHandler;
import net.minecraft.tileentity.TileEntity;

public class SpecialTankHandler {
    private List handlers = new ArrayList();

    public void registerHandler(ISpecialTankHandler handler) {
        try {
            if (handler.init()) {
                this.handlers.add(handler);
                LogisticsPipes.log.info("Loaded SpecialTankHandler: " + handler.getClass().getName());
            } else {
                LogisticsPipes.log.warning("Didn't load SpecialTankHandler: " + handler.getClass().getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getBaseTileFor(TileEntity tile) {
        for (ISpecialTankHandler handler : this.handlers) {
            if (!handler.isType(tile)) continue;
            return handler.getBaseTilesFor(tile);
        }
        return Lists.newArrayList(tile);
    }
}

