/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import gregtechmod.api.interfaces.IDigitalChest;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class DigitalChestHandler
extends SpecialInventoryHandler {
    private final IDigitalChest _tile;
    private final boolean _hideOnePerStack;
    private static boolean apiIsBroken = false;

    private DigitalChestHandler(IDigitalChest tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public DigitalChestHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        if (apiIsBroken) {
            return false;
        }
        try {
            return tile instanceof IDigitalChest && ((IDigitalChest)tile).isDigitalChest() && ((IInventory)tile).func_70302_i_() == 3;
        }
        catch (Throwable e) {
            LogisticsPipes.log.info("Looks like greg broke his API again, disabling Digital/Quantum chest support.");
            apiIsBroken = true;
            return false;
        }
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new DigitalChestHandler((IDigitalChest)tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        ItemIdentifierStack content = this.getContents();
        if (content == null) {
            return 0;
        }
        if (content.getItem() != itemIdent) {
            return 0;
        }
        return content.stackSize - (this._hideOnePerStack ? 1 : 0);
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        ItemIdentifierStack content = this.getContents();
        if (content != null) {
            result.add(content.getItem());
        }
        return result;
    }

    @Override
    public HashMap getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> map = new HashMap<ItemIdentifier, Integer>();
        ItemIdentifierStack content = this.getContents();
        if (content != null) {
            map.put(content.getItem(), content.stackSize - (this._hideOnePerStack ? 1 : 0));
        }
        return map;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsItem(ItemIdentifier itemIdent) {
        ItemIdentifierStack content = this.getContents();
        if (content == null) {
            return false;
        }
        return itemIdent == content.getItem();
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        ItemIdentifierStack content = this.getContents();
        if (content == null) {
            return false;
        }
        return itemIdent.getUndamaged() == content.getItem().getUndamaged();
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        ItemIdentifierStack content = this.getContents();
        if (content == null) {
            return 0;
        }
        if (content.getItem() != itemIdent) {
            return 0;
        }
        return this._tile.getMaxItemCount() + 3 * itemIdent.getMaxStackSize() - content.stackSize;
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        ItemIdentifierStack content = this.getContents();
        if (content == null) {
            return null;
        }
        if (content.getItem() != itemIdent) {
            return null;
        }
        if (content.stackSize < count) {
            return null;
        }
        ItemStack resultstack = content.makeNormalStack();
        resultstack.field_77994_a = count;
        for (int i = 1; count > 0 && i < 3; ++i) {
            ItemStack stack = ((IInventory)this._tile).func_70301_a(i);
            if (stack == null || ItemIdentifier.get(stack) != itemIdent) continue;
            int wanted = Math.min(count, stack.field_77994_a);
            stack.field_77994_a -= wanted;
            count -= wanted;
        }
        if (count == 0) {
            return resultstack;
        }
        ItemStack[] data = this._tile.getStoredItemData();
        int wanted = Math.min(count, data[0].field_77994_a);
        this._tile.setItemCount(data[0].field_77994_a - wanted);
        if ((count -= wanted) == 0) {
            return resultstack;
        }
        ItemStack stack = ((IInventory)this._tile).func_70301_a(0);
        if (stack != null && ItemIdentifier.get(stack) == itemIdent) {
            wanted = Math.min(count, stack.field_77994_a - (this._hideOnePerStack ? 1 : 0));
            stack.field_77994_a -= wanted;
            count -= wanted;
        }
        return resultstack;
    }

    private ItemIdentifierStack getContents() {
        ItemStack[] data = this._tile.getStoredItemData();
        if (data == null || data.length < 1 || data[0] == null || data[0].field_77993_c < 1) {
            return null;
        }
        ItemIdentifierStack dataIdent = ItemIdentifierStack.GetFromStack(data[0]);
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = ((IInventory)this._tile).func_70301_a(i);
            if (stack == null || ItemIdentifier.get(stack) != dataIdent.getItem()) continue;
            dataIdent.stackSize += stack.field_77994_a;
        }
        return dataIdent;
    }

    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        int toadd;
        ItemIdentifier itemIdent = ItemIdentifier.get(stack);
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        ItemIdentifierStack content = this.getContents();
        if (content == null) {
            return st;
        }
        if (content.getItem() != itemIdent) {
            return st;
        }
        if (!doAdd) {
            int space = this._tile.getMaxItemCount() + 3 * itemIdent.getMaxStackSize() - content.stackSize;
            st.field_77994_a = Math.max(Math.min(space, stack.field_77994_a), 0);
            return st;
        }
        ItemStack slot = ((IInventory)this._tile).func_70301_a(0);
        if (slot == null) {
            slot = st.func_77946_l();
            slot.field_77994_a = 0;
        }
        if (ItemIdentifier.get(slot) == itemIdent && (toadd = Math.min(slot.func_77976_d() - slot.field_77994_a, stack.field_77994_a - st.field_77994_a)) > 0) {
            st.field_77994_a += toadd;
            slot.field_77994_a += toadd;
            ((IInventory)this._tile).func_70299_a(0, slot);
        }
        if (stack.field_77994_a - st.field_77994_a == 0) {
            return st;
        }
        ItemStack[] data = this._tile.getStoredItemData();
        int toadd2 = Math.min(this._tile.getMaxItemCount() - data[0].field_77994_a, stack.field_77994_a - st.field_77994_a);
        if (toadd2 > 0) {
            st.field_77994_a += toadd2;
            this._tile.setItemCount(data[0].field_77994_a + toadd2);
        }
        if (stack.field_77994_a - st.field_77994_a == 0) {
            return st;
        }
        for (int i = 1; i < 3; ++i) {
            slot = ((IInventory)this._tile).func_70301_a(i);
            if (slot == null) {
                slot = st.func_77946_l();
                slot.field_77994_a = 0;
            }
            if (ItemIdentifier.get(slot) == itemIdent && (toadd2 = Math.min(slot.func_77976_d() - slot.field_77994_a, stack.field_77994_a - st.field_77994_a)) > 0) {
                st.field_77994_a += toadd2;
                slot.field_77994_a += toadd2;
                ((IInventory)this._tile).func_70299_a(i, slot);
            }
            if (stack.field_77994_a - st.field_77994_a != 0) continue;
            return st;
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if (i != 0) {
            return null;
        }
        return this.getContents().makeNormalStack();
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (i != 0) {
            return null;
        }
        return this.getMultipleItems(this.getContents().getItem(), j);
    }
}

