/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class BarrelInventoryHandler
extends SpecialInventoryHandler {
    private static Class barrelClass;
    private static Method getItemCount;
    private static Method setItemCount;
    private static Method getMaxSize;
    private static Field item;
    private final TileEntity _tile;
    private final boolean _hideOnePerStack;

    private BarrelInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public BarrelInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        try {
            barrelClass = Class.forName("factorization.common.TileEntityBarrel");
            getItemCount = barrelClass.getDeclaredMethod("getItemCount", new Class[0]);
            setItemCount = barrelClass.getDeclaredMethod("setItemCount", Integer.TYPE);
            getMaxSize = barrelClass.getDeclaredMethod("getMaxSize", new Class[0]);
            item = barrelClass.getDeclaredField("item");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isType(TileEntity tile) {
        return barrelClass.isAssignableFrom(tile.getClass());
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new BarrelInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null && ItemIdentifier.get(itemStack) == itemIdent) {
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                return value - (this._hideOnePerStack ? 1 : 0);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null) {
                if (ItemIdentifier.get(itemStack) != itemIdent) {
                    return null;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                if (value - (this._hideOnePerStack ? 1 : 0) < count) {
                    return null;
                }
                setItemCount.invoke((Object)this._tile, value - count);
                ItemStack ret = itemStack.func_77946_l();
                ret.field_77994_a = count;
                return ret;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null) {
                result.add(ItemIdentifier.get(itemStack));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public HashMap getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> map = new HashMap<ItemIdentifier, Integer>();
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null) {
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                map.put(ItemIdentifier.get(itemStack), value - (this._hideOnePerStack ? 1 : 0));
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null) {
                if (ItemIdentifier.get(itemStack) != itemIdent) {
                    return null;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                if (value > (this._hideOnePerStack ? 1 : 0)) {
                    setItemCount.invoke((Object)this._tile, value - 1);
                    ItemStack ret = itemStack.func_77946_l();
                    ret.field_77994_a = 1;
                    return ret;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean containsItem(ItemIdentifier itemIdent) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null) {
                return ItemIdentifier.get(itemStack) == itemIdent;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack != null) {
                return ItemIdentifier.getUndamaged(itemStack) == itemIdent;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            int max = (Integer)getMaxSize.invoke((Object)this._tile, new Object[0]);
            if (itemStack != null) {
                if (ItemIdentifier.get(itemStack) != itemIdent) {
                    return 0;
                }
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                return max - value;
            }
            return max;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        if (from != ForgeDirection.UP) {
            return st;
        }
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            if (itemStack == null) {
                st.field_77994_a = stack.field_77994_a;
                if (doAdd) {
                    ItemStack tst = stack.func_77946_l();
                    if (tst.field_77990_d != null && tst.field_77990_d.func_74740_e().equals("")) {
                        tst.field_77990_d.func_74738_o("tag");
                    }
                    ((IInventory)this._tile).func_70299_a(0, tst);
                }
            } else {
                if (ItemIdentifier.get(itemStack) != ItemIdentifier.get(stack)) {
                    return st;
                }
                int max = (Integer)getMaxSize.invoke((Object)this._tile, new Object[0]);
                int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
                int room = max - value;
                st.field_77994_a = Math.max(Math.min(room, stack.field_77994_a), 0);
                if (doAdd && st.field_77994_a > 0) {
                    setItemCount.invoke((Object)this._tile, value + st.field_77994_a);
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if (i != 0) {
            return null;
        }
        try {
            return (ItemStack)item.get(this._tile);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        try {
            ItemStack itemStack = (ItemStack)item.get(this._tile);
            int value = (Integer)getItemCount.invoke((Object)this._tile, new Object[0]);
            if (value > (this._hideOnePerStack ? 1 : 0)) {
                setItemCount.invoke((Object)this._tile, value - 1);
                ItemStack ret = itemStack.func_77946_l();
                ret.field_77994_a = 1;
                return ret;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

