/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import appeng.api.me.tiles.ITileInterfaceApi;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class AEInterfaceInventoryHandler
extends SpecialInventoryHandler {
    public static boolean init = false;
    private final ITileInterfaceApi _tile;
    private final boolean _hideOnePerStack;
    LinkedList cached;

    private AEInterfaceInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = (ITileInterfaceApi)tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public AEInterfaceInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        init = true;
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof ITileInterfaceApi;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new AEInterfaceInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public Map getItemsAndCount() {
        return this.getItemsAndCount(false);
    }

    private Map getItemsAndCount(boolean linked) {
        HashMap result = linked ? new LinkedHashMap() : new HashMap();
        for (ItemStack items : this._tile.apiGetNetworkContents()) {
            ItemIdentifier ident = ItemIdentifier.get(items);
            Integer count = (Integer)result.get(ident);
            if (count != null) {
                result.put(ident, count + items.field_77994_a - (this._hideOnePerStack ? 1 : 0));
                continue;
            }
            result.put(ident, items.field_77994_a - (this._hideOnePerStack ? 1 : 0));
        }
        return result;
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        for (ItemStack items : this._tile.apiGetNetworkContents()) {
            ItemIdentifier ident = ItemIdentifier.get(items);
            result.add(ident);
        }
        return result;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier item) {
        return this._tile.apiExtractNetworkItem(item.makeNormalStack(1), true);
    }

    @Override
    public boolean containsItem(ItemIdentifier item) {
        ItemStack result = this._tile.apiExtractNetworkItem(item.unsafeMakeNormalStack(1), false);
        return result != null;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier item) {
        for (ItemStack items : this._tile.apiGetNetworkContents()) {
            ItemIdentifier ident = ItemIdentifier.getUndamaged(items);
            if (ident != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, item.getMaxStackSize());
    }

    @Override
    public int roomForItem(ItemIdentifier item, int count) {
        return this._tile.apiCurrentAvailableSpace(item.unsafeMakeNormalStack(1), count);
    }

    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack overflow;
        ItemStack st = stack.func_77946_l();
        ItemStack tst = stack.func_77946_l();
        if (tst.field_77990_d != null && tst.field_77990_d.func_74740_e().equals("")) {
            tst.field_77990_d.func_74738_o("tag");
        }
        if ((overflow = this._tile.apiAddNetworkItem(tst, doAdd)) != null) {
            st.field_77994_a -= overflow.field_77994_a;
        }
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        if (this.cached == null) {
            this.initCache();
        }
        return this.cached.size();
    }

    public void initCache() {
        Map map = this.getItemsAndCount(true);
        this.cached = new LinkedList();
        for (Map.Entry e : map.entrySet()) {
            this.cached.add(e);
        }
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        Map.Entry entry;
        if (this.cached == null) {
            this.initCache();
        }
        if ((Integer)(entry = (Map.Entry)this.cached.get(i)).getValue() == 0) {
            return null;
        }
        return ((ItemIdentifier)entry.getKey()).makeNormalStack((Integer)entry.getValue());
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (this.cached == null) {
            this.initCache();
        }
        Map.Entry entry = (Map.Entry)this.cached.get(i);
        ItemStack stack = ((ItemIdentifier)entry.getKey()).makeNormalStack(j);
        ItemStack extracted = this._tile.apiExtractNetworkItem(stack, true);
        entry.setValue((Integer)entry.getValue() - j);
        return extracted;
    }
}

