/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.recipeproviders;

import java.lang.reflect.Method;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RollingMachine
implements ICraftingRecipeProvider {
    private static Class tileRollingMachineClass;
    private static Method getCraftMatrixMethod;

    public static boolean load() {
        try {
            tileRollingMachineClass = Class.forName("mods.railcraft.common.blocks.machine.alpha.TileRollingMachine");
            getCraftMatrixMethod = tileRollingMachineClass.getMethod("getCraftMatrix", new Class[0]);
        }
        catch (Exception ex) {
            LogisticsPipes.log.fine("Necessary classes from Railcraft were not found");
            return false;
        }
        return true;
    }

    @Override
    public boolean canOpenGui(TileEntity tile) {
        return tileRollingMachineClass.isInstance(tile);
    }

    private ItemStack getResult(InventoryCrafting inventorycrafting, World world) {
        if (inventorycrafting == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName("mods.railcraft.common.util.crafting.RollingMachineCraftingManager");
            Method inst = c.getMethod("getInstance", new Class[0]);
            Object instance = inst.invoke(null, new Object[0]);
            Method findMatchingRecipe = c.getMethod("findMatchingRecipe", InventoryCrafting.class, World.class);
            return (ItemStack)findMatchingRecipe.invoke(instance, inventorycrafting, world);
        }
        catch (Exception ex) {
            LogisticsPipes.log.fine("getResult fail");
            return null;
        }
    }

    private InventoryCrafting getCraftMatrix(TileEntity tile) {
        try {
            return (InventoryCrafting)getCraftMatrixMethod.invoke((Object)tile, new Object[0]);
        }
        catch (Exception ex) {
            LogisticsPipes.log.fine("getCraftMatrix fail");
            return null;
        }
    }

    @Override
    public boolean importRecipe(TileEntity tile, SimpleInventory inventory) {
        int i;
        if (!tileRollingMachineClass.isInstance(tile)) {
            return false;
        }
        InventoryCrafting craftMatrix = this.getCraftMatrix(tile);
        if (craftMatrix == null) {
            return false;
        }
        ItemStack result = this.getResult(craftMatrix, tile.field_70331_k);
        if (result == null) {
            return false;
        }
        inventory.func_70299_a(9, result);
        for (i = 0; i < craftMatrix.func_70302_i_() && i < inventory.func_70302_i_() - 2; ++i) {
            ItemStack newStack = craftMatrix.func_70301_a(i) == null ? null : craftMatrix.func_70301_a(i).func_77946_l();
            inventory.func_70299_a(i, newStack);
        }
        for (i = 0; i < inventory.func_70302_i_() - 2; ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null) continue;
            ItemIdentifier itemInSlot = ItemIdentifier.get(stackInSlot);
            for (int j = i + 1; j < inventory.func_70302_i_() - 2; ++j) {
                ItemStack stackInOtherSlot = inventory.func_70301_a(j);
                if (stackInOtherSlot == null || itemInSlot != ItemIdentifier.get(stackInOtherSlot)) continue;
                stackInSlot.field_77994_a += stackInOtherSlot.field_77994_a;
                inventory.func_70299_a(j, null);
            }
        }
        block3: for (i = 0; i < inventory.func_70302_i_() - 2; ++i) {
            if (inventory.func_70301_a(i) != null) continue;
            for (int j = i + 1; j < inventory.func_70302_i_() - 2; ++j) {
                if (inventory.func_70301_a(j) == null) continue;
                inventory.func_70299_a(i, inventory.func_70301_a(j));
                inventory.func_70299_a(j, null);
                continue block3;
            }
        }
        return true;
    }
}

