/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.recipeproviders;

import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.CraftingUtil;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;

public class ImmibisCraftingTableMk2
implements ICraftingRecipeProvider {
    private static Class tileAutoCraftingMk2;

    public static boolean load() {
        try {
            tileAutoCraftingMk2 = Class.forName("mods.immibis.tubestuff.TileAutoCraftingMk2");
            return true;
        }
        catch (Exception e) {
            LogisticsPipes.log.fine("Necessary classes from Tubestuff were not found");
            return false;
        }
    }

    @Override
    public boolean canOpenGui(TileEntity tile) {
        return tileAutoCraftingMk2.isInstance(tile);
    }

    @Override
    public boolean importRecipe(TileEntity tile, SimpleInventory inventory) {
        try {
            if (tileAutoCraftingMk2.isInstance(tile)) {
                ItemStack[][] recipe = (ItemStack[][])tileAutoCraftingMk2.getField("recipeInputs").get(tile);
                InventoryCrafting tempCraftingInv = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer entityplayer) {
                        return false;
                    }

                    public void func_75130_a(IInventory par1iInventory) {
                    }
                }, 3, 3);
                for (int i = 0; i < 9; ++i) {
                    if (recipe[i].length > 0) {
                        tempCraftingInv.func_70299_a(i, recipe[i][0]);
                        inventory.func_70299_a(i, recipe[i][0]);
                        continue;
                    }
                    inventory.func_70299_a(i, null);
                }
                int slotCount = 0;
                for (int i = 0; i < 9; ++i) {
                    ItemStack slotStack = inventory.func_70301_a(i);
                    inventory.func_70299_a(i, null);
                    if (slotStack == null || slotStack.func_77973_b() == null) continue;
                    int count = 1;
                    for (int j = i + 1; j < 9; ++j) {
                        ItemStack tempStack = inventory.func_70301_a(j);
                        if (tempStack == null || ItemIdentifier.get(slotStack) != ItemIdentifier.get(tempStack)) continue;
                        inventory.func_70299_a(j, null);
                        ++count;
                    }
                    slotStack.field_77994_a = count;
                    inventory.func_70299_a(slotCount, slotStack);
                    ++slotCount;
                }
                ItemStack result = null;
                for (IRecipe r : CraftingUtil.getRecipeList()) {
                    if (!r.func_77569_a(tempCraftingInv, tile.func_70314_l())) continue;
                    result = r.func_77572_b(tempCraftingInv);
                    break;
                }
                inventory.func_70299_a(9, result);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            LogisticsPipes.log.severe("Error while importing recipe from Tubestuff's AutoCraftingMk2");
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            LogisticsPipes.log.severe("Error while importing recipe from Tubestuff's AutoCraftingMk2");
            e.printStackTrace();
        }
        catch (Exception e) {
            LogisticsPipes.log.finer("Got a problem on ImmibisCraftingTableMk2 CraftingRecipeProvider:");
            LogisticsPipes.log.finer(e.getMessage());
        }
        return false;
    }
}

