/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Localization;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.EntityData;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.TransportProxyClient;
import buildcraft.transport.render.RenderPipe;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.gates.ActionDisableLogistics;
import logisticspipes.gates.LogisticsTriggerProvider;
import logisticspipes.gates.TriggerCrafting;
import logisticspipes.gates.TriggerHasDestination;
import logisticspipes.gates.TriggerNeedsPower;
import logisticspipes.gates.TriggerSupplierFailed;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.PipeItemsApiaristAnalyser;
import logisticspipes.pipes.PipeItemsApiaristSink;
import logisticspipes.pipes.PipeItemsBasicLogistics;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsCraftingLogisticsMk2;
import logisticspipes.pipes.PipeItemsCraftingLogisticsMk3;
import logisticspipes.pipes.PipeItemsFirewall;
import logisticspipes.pipes.PipeItemsInvSysConnector;
import logisticspipes.pipes.PipeItemsLiquidSupplier;
import logisticspipes.pipes.PipeItemsProviderLogistics;
import logisticspipes.pipes.PipeItemsProviderLogisticsMk2;
import logisticspipes.pipes.PipeItemsRemoteOrdererLogistics;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.pipes.PipeItemsRequestLogisticsMk2;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.pipes.PipeItemsSupplierLogistics;
import logisticspipes.pipes.PipeItemsSystemDestinationLogistics;
import logisticspipes.pipes.PipeItemsSystemEntranceLogistics;
import logisticspipes.pipes.PipeLiquidBasic;
import logisticspipes.pipes.PipeLiquidExtractor;
import logisticspipes.pipes.PipeLiquidInsertion;
import logisticspipes.pipes.PipeLiquidProvider;
import logisticspipes.pipes.PipeLiquidRequestLogistics;
import logisticspipes.pipes.PipeLiquidSatellite;
import logisticspipes.pipes.PipeLiquidSupplierMk2;
import logisticspipes.pipes.PipeLogisticsChassiMk1;
import logisticspipes.pipes.PipeLogisticsChassiMk2;
import logisticspipes.pipes.PipeLogisticsChassiMk3;
import logisticspipes.pipes.PipeLogisticsChassiMk4;
import logisticspipes.pipes.PipeLogisticsChassiMk5;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.liquid.LogisticsLiquidConnectorPipe;
import logisticspipes.renderer.LogisticsPipeBlockRenderer;
import logisticspipes.routing.RoutedEntityItem;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.ForgeDirection;

public class BuildCraftProxy {
    public static List pipelist = new ArrayList();
    public static ITrigger LogisticsFailedTrigger;
    public static ITrigger LogisticsCraftingTrigger;
    public static ITrigger LogisticsNeedPowerTrigger;
    public static ITrigger LogisticsHasDestinationTrigger;
    public static IAction LogisticsDisableAction;
    private Method arePipesConnected;

    public boolean checkPipesConnections(TileEntity from, TileEntity to, ForgeDirection way) {
        return this.checkPipesConnections(from, to, way, false);
    }

    public boolean checkPipesConnections(TileEntity from, TileEntity to, ForgeDirection way, boolean ignoreSystemDisconnection) {
        if (from instanceof TileGenericPipe && to instanceof TileGenericPipe && (((TileGenericPipe)from).pipe instanceof CoreRoutedPipe || ((TileGenericPipe)to).pipe instanceof CoreRoutedPipe)) {
            if (((TileGenericPipe)from).pipe instanceof CoreRoutedPipe) {
                if (!((CoreRoutedPipe)((TileGenericPipe)from).pipe).canPipeConnect(to, way, ignoreSystemDisconnection)) {
                    return false;
                }
            } else {
                ((CoreRoutedPipe)((TileGenericPipe)to).pipe).globalIgnoreConnectionDisconnection = true;
                if (!this.arePipesConnected((TileGenericPipe)from, to, way)) {
                    ((CoreRoutedPipe)((TileGenericPipe)to).pipe).globalIgnoreConnectionDisconnection = false;
                    return false;
                }
                ((CoreRoutedPipe)((TileGenericPipe)to).pipe).globalIgnoreConnectionDisconnection = false;
            }
            if (((TileGenericPipe)to).pipe instanceof CoreRoutedPipe) {
                if (!((CoreRoutedPipe)((TileGenericPipe)to).pipe).canPipeConnect(from, way.getOpposite(), ignoreSystemDisconnection)) {
                    return false;
                }
            } else {
                ((CoreRoutedPipe)((TileGenericPipe)from).pipe).globalIgnoreConnectionDisconnection = true;
                if (!this.arePipesConnected((TileGenericPipe)to, from, way.getOpposite())) {
                    ((CoreRoutedPipe)((TileGenericPipe)from).pipe).globalIgnoreConnectionDisconnection = false;
                    return false;
                }
                ((CoreRoutedPipe)((TileGenericPipe)from).pipe).globalIgnoreConnectionDisconnection = false;
            }
            return true;
        }
        return Utils.checkPipesConnections((TileEntity)from, (TileEntity)to);
    }

    public boolean initProxyAndCheckVersion() {
        try {
            this.arePipesConnected = TileGenericPipe.class.getDeclaredMethod("arePipesConnected", TileEntity.class, ForgeDirection.class);
            this.arePipesConnected.setAccessible(true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("You seem to have an outdated Buildcraft version. Please update to the newest BuildCraft version to run LogisticsPipes.");
        }
    }

    public boolean arePipesConnected(TileGenericPipe tile, TileEntity with, ForgeDirection side) {
        try {
            return (Boolean)this.arePipesConnected.invoke((Object)tile, with, side);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void dropItems(World world, IInventory inventory, int x, int y, int z) {
        Utils.dropItems((World)world, (IInventory)inventory, (int)x, (int)y, (int)z);
    }

    public void dropItems(World world, ItemStack stack, int x, int y, int z) {
        Utils.dropItems((World)world, (ItemStack)stack, (int)x, (int)y, (int)z);
    }

    public IRoutedItem GetOrCreateRoutedItem(World worldObj, EntityData itemData) {
        if (!this.isRoutedItem(itemData.item)) {
            RoutedEntityItem newItem = new RoutedEntityItem(worldObj, itemData.item);
            itemData.item = newItem;
            return newItem;
        }
        return (IRoutedItem)itemData.item;
    }

    public boolean isRoutedItem(IPipedItem item) {
        return item instanceof RoutedEntityItem;
    }

    public IRoutedItem GetRoutedItem(IPipedItem item) {
        return (IRoutedItem)item;
    }

    public IRoutedItem CreateRoutedItem(World worldObj, IPipedItem item) {
        RoutedEntityItem newItem = new RoutedEntityItem(worldObj, item);
        return newItem;
    }

    public IRoutedItem CreateRoutedItem(ItemStack payload, World worldObj) {
        EntityPassiveItem entityItem = new EntityPassiveItem(worldObj, 0.0, 0.0, 0.0, payload);
        return this.CreateRoutedItem(worldObj, (IPipedItem)entityItem);
    }

    public void registerTrigger() {
        ActionManager.registerTriggerProvider((ITriggerProvider)new LogisticsTriggerProvider());
        LogisticsFailedTrigger = new TriggerSupplierFailed(700);
        LogisticsNeedPowerTrigger = new TriggerNeedsPower(701);
        LogisticsCraftingTrigger = new TriggerCrafting(702);
        LogisticsHasDestinationTrigger = new TriggerHasDestination(703);
        LogisticsDisableAction = new ActionDisableLogistics(700);
    }

    public void registerLocalization() {
        Localization.addLocalization((String)"/lang/logisticspipes/", (String)"en_US");
    }

    public void registerPipes(Side side) {
        LogisticsPipes.LogisticsBasicPipe = this.createPipe(Configs.LOGISTICSPIPE_BASIC_ID, PipeItemsBasicLogistics.class, "Basic Logistics Pipe", side);
        LogisticsPipes.LogisticsRequestPipeMk1 = this.createPipe(Configs.LOGISTICSPIPE_REQUEST_ID, PipeItemsRequestLogistics.class, "Request Logistics Pipe", side);
        LogisticsPipes.LogisticsProviderPipeMk1 = this.createPipe(Configs.LOGISTICSPIPE_PROVIDER_ID, PipeItemsProviderLogistics.class, "Provider Logistics Pipe", side);
        LogisticsPipes.LogisticsCraftingPipeMk1 = this.createPipe(Configs.LOGISTICSPIPE_CRAFTING_ID, PipeItemsCraftingLogistics.class, "Crafting Logistics Pipe", side);
        LogisticsPipes.LogisticsSatellitePipe = this.createPipe(Configs.LOGISTICSPIPE_SATELLITE_ID, PipeItemsSatelliteLogistics.class, "Satellite Logistics Pipe", side);
        LogisticsPipes.LogisticsSupplierPipe = this.createPipe(Configs.LOGISTICSPIPE_SUPPLIER_ID, PipeItemsSupplierLogistics.class, "Supplier Logistics Pipe", side);
        LogisticsPipes.LogisticsChassisPipeMk1 = this.createPipe(Configs.LOGISTICSPIPE_CHASSI1_ID, PipeLogisticsChassiMk1.class, "Logistics Chassi Mk1", side);
        LogisticsPipes.LogisticsChassisPipeMk2 = this.createPipe(Configs.LOGISTICSPIPE_CHASSI2_ID, PipeLogisticsChassiMk2.class, "Logistics Chassi Mk2", side);
        LogisticsPipes.LogisticsChassisPipeMk3 = this.createPipe(Configs.LOGISTICSPIPE_CHASSI3_ID, PipeLogisticsChassiMk3.class, "Logistics Chassi Mk3", side);
        LogisticsPipes.LogisticsChassisPipeMk4 = this.createPipe(Configs.LOGISTICSPIPE_CHASSI4_ID, PipeLogisticsChassiMk4.class, "Logistics Chassi Mk4", side);
        LogisticsPipes.LogisticsChassisPipeMk5 = this.createPipe(Configs.LOGISTICSPIPE_CHASSI5_ID, PipeLogisticsChassiMk5.class, "Logistics Chassi Mk5", side);
        LogisticsPipes.LogisticsCraftingPipeMk2 = this.createPipe(Configs.LOGISTICSPIPE_CRAFTING_MK2_ID, PipeItemsCraftingLogisticsMk2.class, "Crafting Logistics Pipe MK2", side);
        LogisticsPipes.LogisticsRequestPipeMk2 = this.createPipe(Configs.LOGISTICSPIPE_REQUEST_MK2_ID, PipeItemsRequestLogisticsMk2.class, "Request Logistics Pipe MK2", side);
        LogisticsPipes.LogisticsRemoteOrdererPipe = this.createPipe(Configs.LOGISTICSPIPE_REMOTE_ORDERER_ID, PipeItemsRemoteOrdererLogistics.class, "Remote Orderer Pipe", side);
        LogisticsPipes.LogisticsProviderPipeMk2 = this.createPipe(Configs.LOGISTICSPIPE_PROVIDER_MK2_ID, PipeItemsProviderLogisticsMk2.class, "Provider Logistics Pipe MK2", side);
        LogisticsPipes.LogisticsApiaristAnalyzerPipe = this.createPipe(Configs.LOGISTICSPIPE_APIARIST_ANALYSER_ID, PipeItemsApiaristAnalyser.class, "Apiarist Logistics Analyser Pipe", side);
        LogisticsPipes.LogisticsApiaristSinkPipe = this.createPipe(Configs.LOGISTICSPIPE_APIARIST_SINK_ID, PipeItemsApiaristSink.class, "Apiarist Logistics Analyser Pipe", side);
        LogisticsPipes.LogisticsInvSysConPipe = this.createPipe(Configs.LOGISTICSPIPE_INVSYSCON_ID, PipeItemsInvSysConnector.class, "Logistics Inventory System Connector", side);
        LogisticsPipes.LogisticsEntrancePipe = this.createPipe(Configs.LOGISTICSPIPE_ENTRANCE_ID, PipeItemsSystemEntranceLogistics.class, "Logistics System Entrance Pipe", side);
        LogisticsPipes.LogisticsDestinationPipe = this.createPipe(Configs.LOGISTICSPIPE_DESTINATION_ID, PipeItemsSystemDestinationLogistics.class, "Logistics System Destination Pipe", side);
        LogisticsPipes.LogisticsCraftingPipeMk3 = this.createPipe(Configs.LOGISTICSPIPE_CRAFTING_MK3_ID, PipeItemsCraftingLogisticsMk3.class, "Crafting Logistics Pipe MK3", side);
        LogisticsPipes.LogisticsFirewallPipe = this.createPipe(Configs.LOGISTICSPIPE_FIREWALL_ID, PipeItemsFirewall.class, "Firewall Logistics Pipe", side);
        LogisticsPipes.LogisticsLiquidSupplierPipeMk1 = this.createPipe(Configs.LOGISTICSPIPE_LIQUIDSUPPLIER_ID, PipeItemsLiquidSupplier.class, "Liquid Supplier Logistics Pipe", side);
        LogisticsPipes.LogisticsLiquidConnectorPipe = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_CONNECTOR, LogisticsLiquidConnectorPipe.class, "Logistics Liquid Connector Pipe", side);
        LogisticsPipes.LogisticsLiquidBasicPipe = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_BASIC, PipeLiquidBasic.class, "Basic Logistics Liquid Pipe", side);
        LogisticsPipes.LogisticsLiquidInsertionPipe = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_INSERTION, PipeLiquidInsertion.class, "Logistics Liquid Insertion Pipe", side);
        LogisticsPipes.LogisticsLiquidProviderPipe = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_PROVIDER, PipeLiquidProvider.class, "Logistics Liquid Provider Pipe", side);
        LogisticsPipes.LogisticsLiquidRequestPipe = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_REQUEST, PipeLiquidRequestLogistics.class, "Logistics Liquid Request Pipe", side);
        LogisticsPipes.LogisticsLiquidExtractorPipe = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_EXTRACTOR, PipeLiquidExtractor.class, "Logistics Liquid Extractor Pipe", side);
        LogisticsPipes.LogisticsLiquidSatellitePipe = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_SATELLITE, PipeLiquidSatellite.class, "Logistics Liquid Satellite Pipe", side);
        LogisticsPipes.LogisticsLiquidSupplierPipeMk2 = this.createPipe(Configs.LOGISTICSPIPE_LIQUID_SUPPLIER_MK2, PipeLiquidSupplierMk2.class, "Logistics Liquid Supplier Pipe Mk2", side);
        LogisticsPipes.logisticsRequestTable = this.createPipe(Configs.LOGISTICSPIPE_REQUEST_TABLE_ID, PipeBlockRequestTable.class, "Request Table", side);
    }

    public static ItemPipe registerPipe(int key, Class clas) {
        ItemLogisticsPipe item = new ItemLogisticsPipe(key, clas);
        Map pipes = null;
        try {
            pipes = BlockGenericPipe.pipes;
        }
        catch (NoSuchFieldError e) {
            try {
                pipes = (Map)BlockGenericPipe.class.getDeclaredField("pipes").get(null);
            }
            catch (Exception e2) {
                return null;
            }
        }
        pipes.put(item.field_77779_bT, clas);
        Pipe dummyPipe = BlockGenericPipe.createPipe((int)item.field_77779_bT);
        if (dummyPipe != null) {
            item.setPipeIconIndex(dummyPipe.getIconIndexForItem());
            TransportProxy.proxy.setIconProviderFromPipe((ItemPipe)item, dummyPipe);
        }
        return item;
    }

    protected Item createPipe(int defaultID, Class clas, String descr, Side side) {
        ItemPipe res = BuildCraftProxy.registerPipe(defaultID, clas);
        res.func_77637_a((CreativeTabs)LogisticsPipes.LPCreativeTab);
        res.func_77655_b(clas.getSimpleName());
        Pipe pipe = BlockGenericPipe.createPipe((int)res.field_77779_bT);
        if (pipe instanceof CoreRoutedPipe) {
            res.setPipeIconIndex(((CoreRoutedPipe)pipe).getTextureType((ForgeDirection)ForgeDirection.UNKNOWN).normal);
        }
        if (side.isClient()) {
            if (pipe instanceof PipeBlockRequestTable) {
                MinecraftForgeClient.registerItemRenderer((int)res.field_77779_bT, (IItemRenderer)new LogisticsPipeBlockRenderer());
            } else {
                MinecraftForgeClient.registerItemRenderer((int)res.field_77779_bT, (IItemRenderer)TransportProxyClient.pipeItemRenderer);
            }
        }
        if (defaultID != Configs.LOGISTICSPIPE_BASIC_ID && defaultID != Configs.LOGISTICSPIPE_LIQUID_CONNECTOR) {
            this.registerShapelessResetRecipe((Item)res, 0, LogisticsPipes.LogisticsBasicPipe, 0);
        }
        pipelist.add(res);
        return res;
    }

    protected void registerShapelessResetRecipe(Item fromItem, int fromData, Item toItem, int toData) {
        for (int j = 1; j < 10; ++j) {
            Object[] obj = new Object[j];
            for (int k = 0; k < j; ++k) {
                obj[k] = new ItemStack(fromItem, 1, toData);
            }
            CraftingManager.func_77594_a().func_77596_b(new ItemStack(toItem, j, fromData), obj);
        }
    }

    public boolean checkMaxItems() {
        return BuildCraftTransport.maxItemsInPipes >= 1000;
    }

    public boolean isWrenchEquipped(EntityPlayer entityplayer) {
        return entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof IToolWrench;
    }

    public boolean isUpgradeManagerEquipped(EntityPlayer entityplayer) {
        return entityplayer != null && entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().field_77993_c == LogisticsPipes.LogisticsUpgradeManager.field_77779_bT;
    }

    public void resetItemRotation(RenderPipe renderer) {
        try {
            Field f = RenderPipe.class.getDeclaredField("dummyEntityItem");
            f.setAccessible(true);
            EntityItem item = (EntityItem)f.get(renderer);
            item.field_70290_d = 0.0f;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void replaceBlockGenericPipe() {
        if (Block.field_71973_m[BuildCraftTransport.genericPipeBlock.field_71990_ca] == BuildCraftTransport.genericPipeBlock) {
            Block.field_71973_m[BuildCraftTransport.genericPipeBlock.field_71990_ca] = null;
            BuildCraftTransport.genericPipeBlock = new LogisticsBlockGenericPipe(BuildCraftTransport.genericPipeBlock.field_71990_ca);
        }
    }
}

