/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic.liquid;

import buildcraft.core.IMachine;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequireReliableLiquidTransport;
import logisticspipes.items.LogisticsLiquidContainer;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.logic.TemporaryLogic;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.liquid.LogisticsLiquidConnectorPipe;
import logisticspipes.pipes.basic.liquid.LogisticsLiquidSection;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import logisticspipes.utils.WorldUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public abstract class LiquidRoutedPipe
extends CoreRoutedPipe
implements IItemTravelingHook {
    private WorldUtil worldUtil;

    public LiquidRoutedPipe(int itemID) {
        super(new PipeLiquidTransportLogistics(), new TemporaryLogic(), itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
        this.worldUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
    }

    public LiquidRoutedPipe(BaseRoutingLogic logic, int itemID) {
        super(new PipeLiquidTransportLogistics(), logic, itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
        this.worldUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
    }

    public void setTile(TileEntity tile) {
        super.setTile(tile);
        this.worldUtil = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean logisitcsIsPipeConnected(TileEntity tile) {
        ITankContainer liq;
        if (tile instanceof ITankContainer && (liq = (ITankContainer)tile).getTanks(ForgeDirection.UNKNOWN) != null && liq.getTanks(ForgeDirection.UNKNOWN).length > 0) {
            return true;
        }
        return tile instanceof TileGenericPipe || tile instanceof IMachine && ((IMachine)tile).manageLiquids();
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        if (this.isLiquidSidedTexture(connection)) {
            return Textures.LOGISTICSPIPE_LIQUID_TEXTURE;
        }
        return super.getNonRoutedTexture(connection);
    }

    private boolean isLiquidSidedTexture(ForgeDirection connection) {
        ITankContainer liq;
        WorldUtil util = new WorldUtil(this.worldObj, this.getX(), this.getY(), this.getZ());
        TileEntity tile = util.getAdjacentTileEntitie(connection);
        if (tile instanceof ITankContainer && (liq = (ITankContainer)tile).getTanks(ForgeDirection.UNKNOWN) != null && liq.getTanks(ForgeDirection.UNKNOWN).length > 0) {
            return true;
        }
        if (tile instanceof TileGenericPipe) {
            return ((TileGenericPipe)tile).pipe instanceof LogisticsLiquidConnectorPipe;
        }
        return false;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public final List getAdjacentTanks(boolean flag) {
        ArrayList<Pair> tileList = new ArrayList<Pair>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.worldUtil.getAdjacentTileEntitie(dir);
            if (!this.isConnectableTank(tile, dir, flag)) continue;
            tileList.add(new Pair(tile, dir));
        }
        return tileList;
    }

    public final boolean isConnectableTank(TileEntity tile, ForgeDirection dir, boolean flag) {
        if (!(tile instanceof ITankContainer)) {
            return false;
        }
        if (!this.canPipeConnect(tile, dir)) {
            return false;
        }
        if (tile instanceof TileGenericPipe) {
            if (((TileGenericPipe)tile).pipe instanceof LiquidRoutedPipe) {
                return false;
            }
            if (!flag) {
                return false;
            }
            if (((TileGenericPipe)tile).pipe == null || !(((TileGenericPipe)tile).pipe.transport instanceof ITankContainer)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.canInsertFromSideToTanks()) {
            int validDirections = 0;
            List list = this.getAdjacentTanks(true);
            for (Pair pair : list) {
                LiquidStack drain;
                int filled;
                if (pair.getValue1() instanceof TileGenericPipe && ((TileGenericPipe)pair.getValue1()).pipe instanceof CoreRoutedPipe) continue;
                LogisticsLiquidSection tank = ((PipeLiquidTransportLogistics)this.transport).sideTanks[((ForgeDirection)pair.getValue2()).ordinal()];
                ++validDirections;
                if (tank.getLiquid() == null || (filled = ((ITankContainer)pair.getValue1()).fill(((ForgeDirection)pair.getValue2()).getOpposite(), tank.getLiquid(), true)) == 0 || (drain = tank.drain(filled, true)) != null && filled == drain.amount || !LogisticsPipes.DEBUG) continue;
                throw new UnsupportedOperationException("Liquid Multiplication");
            }
            if (validDirections == 0) {
                return;
            }
            LogisticsLiquidSection tank = ((PipeLiquidTransportLogistics)this.transport).internalTank;
            LiquidStack stack = tank.getLiquid();
            if (stack == null) {
                return;
            }
            for (Pair pair : list) {
                LiquidStack drain;
                int filled;
                if (pair.getValue1() instanceof TileGenericPipe && ((TileGenericPipe)pair.getValue1()).pipe instanceof CoreRoutedPipe) continue;
                LogisticsLiquidSection tankSide = ((PipeLiquidTransportLogistics)this.transport).sideTanks[((ForgeDirection)pair.getValue2()).ordinal()];
                stack = tank.getLiquid();
                if (stack == null || (filled = tankSide.fill(stack = stack.copy(), true)) == 0 || (drain = tank.drain(filled, true)) != null && filled == drain.amount || !LogisticsPipes.DEBUG) continue;
                throw new UnsupportedOperationException("Liquid Multiplication");
            }
        }
    }

    public int countOnRoute(LiquidIdentifier ident) {
        int amount = 0;
        for (IRoutedItem next : this._inTransitToMe) {
            LiquidStack liquid;
            ItemStack item = next.getItemStack();
            if (!(item.func_77973_b() instanceof LogisticsLiquidContainer) || LiquidIdentifier.get(liquid = SimpleServiceLocator.logisticsLiquidManager.getLiquidFromContainer(item)) != ident) continue;
            amount += liquid.amount;
        }
        return amount;
    }

    public abstract boolean canInsertFromSideToTanks();

    public abstract boolean canInsertToTanks();

    public void drop(PipeTransportItems pipe, EntityData data) {
    }

    public void centerReached(PipeTransportItems pipe, EntityData data) {
    }

    public void endReached(PipeTransportItems pipe, EntityData data, TileEntity tile) {
        ((PipeTransportLogistics)pipe).markChunkModified(tile);
        if (this.canInsertToTanks() && MainProxy.isServer(this.worldObj)) {
            if (!(data.item instanceof IRoutedItem) || data.item.getItemStack() == null || !(data.item.getItemStack().func_77973_b() instanceof LogisticsLiquidContainer)) {
                return;
            }
            if (this.getRouter().getSimpleID() != ((IRoutedItem)data.item).getDestination()) {
                return;
            }
            ((PipeTransportItems)this.transport).scheduleRemoval(data.item);
            int filled = 0;
            LiquidStack liquid = SimpleServiceLocator.logisticsLiquidManager.getLiquidFromContainer(data.item.getItemStack());
            if (this.isConnectableTank(tile, data.output, false)) {
                List adjTanks = this.getAdjacentTanks(false);
                for (int i = 0; i < adjTanks.size(); ++i) {
                    Pair pair = (Pair)adjTanks.get(i);
                    ITankContainer tank = (ITankContainer)pair.getValue1();
                    ForgeDirection dir = (ForgeDirection)pair.getValue2();
                    filled = tank.fill(dir.getOpposite(), liquid, true);
                    liquid.amount -= filled;
                    if (liquid.amount != 0) continue;
                    return;
                }
                filled = ((PipeLiquidTransportLogistics)this.transport).sideTanks[data.output.ordinal()].fill(liquid, true);
                if (filled == liquid.amount) {
                    return;
                }
                liquid.amount -= filled;
            }
            if ((filled = ((PipeLiquidTransportLogistics)this.transport).internalTank.fill(liquid, true)) == liquid.amount) {
                return;
            }
            liquid.amount -= filled;
            if (this.logic instanceof IRequireReliableLiquidTransport) {
                ((IRequireReliableLiquidTransport)this.logic).liquidNotInserted(LiquidIdentifier.get(liquid), liquid.amount);
            }
            IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(SimpleServiceLocator.logisticsLiquidManager.getLiquidContainer(liquid), this.worldObj);
            Pair replies = SimpleServiceLocator.logisticsLiquidManager.getBestReply(liquid, this.getRouter(), routedItem.getJamList());
            int dest = (Integer)replies.getValue1();
            routedItem.setDestination(dest);
            routedItem.setTransportMode(IRoutedItem.TransportMode.Passive);
            this.queueRoutedItem(routedItem, data.output.getOpposite());
        }
    }

    @Override
    public boolean isLiquidPipe() {
        return true;
    }

    public boolean sharesTankWith(LiquidRoutedPipe other) {
        List theirs = other.getAllTankTiles();
        for (TileEntity tile : this.getAllTankTiles()) {
            if (!theirs.contains(tile)) continue;
            return true;
        }
        return false;
    }

    public List getAllTankTiles() {
        ArrayList list = new ArrayList();
        for (Pair pair : this.getAdjacentTanks(false)) {
            list.addAll(SimpleServiceLocator.specialTankHandler.getBaseTileFor((TileEntity)pair.getValue1()));
        }
        return list;
    }
}

