/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.interfaces.routing.IRequireReliableLiquidTransport;
import logisticspipes.logic.LogicLiquidSupplierMk2;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.liquid.LiquidRoutedPipe;
import logisticspipes.textures.Textures;
import logisticspipes.utils.LiquidIdentifier;

public class PipeLiquidSupplierMk2
extends LiquidRoutedPipe
implements IRequestLiquid {
    private boolean _lastRequestFailed = false;

    public PipeLiquidSupplierMk2(int ItemID) {
        super(new LogicLiquidSupplierMk2(), ItemID);
        ((LogicLiquidSupplierMk2)this.logic)._power = this;
    }

    @Override
    public void sendFailed(LiquidIdentifier value1, Integer value2) {
        if (this.logic instanceof IRequireReliableLiquidTransport) {
            ((IRequireReliableLiquidTransport)this.logic).liquidLost(value1, value2);
        }
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUIDSUPPLIER_MK2_TEXTURE;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }
}

