/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import cpw.mods.fml.common.network.Player;
import java.util.Collection;
import java.util.LinkedList;
import logisticspipes.gui.hud.HUDSatellite;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.interfaces.routing.IRequireReliableLiquidTransport;
import logisticspipes.logic.BaseLogicLiquidSatellite;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleSatelite;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.packets.hud.ChestContent;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.satpipe.SatPipeSetID;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.liquid.LiquidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.textures.Textures;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import logisticspipes.utils.PlayerCollectionList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidSatellite
extends LiquidRoutedPipe
implements IRequestLiquid,
IHeadUpDisplayRendererProvider,
IChestContentReceiver {
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    public final LinkedList itemList = new LinkedList();
    public final LinkedList oldList = new LinkedList();
    private final HUDSatellite HUD = new HUDSatellite(this);

    public PipeLiquidSatellite(int itemID) {
        super(new BaseLogicLiquidSatellite(), itemID);
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_SATELLITE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return new ModuleSatelite(this);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.worldObj.func_72820_D() % 20L == 0L && this.localModeWatchers.size() > 0) {
            this.updateInv(false);
        }
    }

    @Override
    public void sendFailed(LiquidIdentifier liquid, Integer amount) {
        if (this.logic instanceof IRequireReliableLiquidTransport) {
            ((IRequireReliableLiquidTransport)this.logic).liquidLost(liquid, amount);
        }
    }

    private void addToList(ItemIdentifierStack stack) {
        for (ItemIdentifierStack ident : this.itemList) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.stackSize += stack.stackSize;
            return;
        }
        this.itemList.addLast(stack);
    }

    private void updateInv(boolean force) {
        this.itemList.clear();
        for (Pair pair : this.getAdjacentTanks(false)) {
            ILiquidTank[] tanks;
            if (!(pair.getValue1() instanceof ITankContainer)) continue;
            ITankContainer tankContainer = (ITankContainer)pair.getValue1();
            for (ILiquidTank tank : tanks = tankContainer.getTanks(((ForgeDirection)pair.getValue2()).getOpposite())) {
                LiquidStack liquid = tank.getLiquid();
                if (liquid == null) continue;
                this.addToList(LiquidIdentifier.get(liquid).getItemIdentifier().makeStack(liquid.amount));
            }
        }
        if (!this.itemList.equals(this.oldList) || force) {
            this.oldList.clear();
            this.oldList.addAll(this.itemList);
            MainProxy.sendToPlayerList(((ChestContent)PacketHandler.getPacket(ChestContent.class)).setIdentList(this.itemList).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void setReceivedChestContent(Collection list) {
        this.itemList.clear();
        this.itemList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(((HUDStartWatchingPacket)PacketHandler.getPacket(HUDStartWatchingPacket.class)).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(((HUDStopWatchingPacket)PacketHandler.getPacket(HUDStopWatchingPacket.class)).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            CoordinatesPacket packet = ((SatPipeSetID)PacketHandler.getPacket(SatPipeSetID.class)).setSatID(((BaseLogicLiquidSatellite)this.logic).satelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToPlayer(packet, (Player)player);
            this.updateInv(true);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }
}

