/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;
import logisticspipes.pipes.PipeLiquidInsertion;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidExtractor
extends PipeLiquidInsertion {
    private int[] liquidToExtract = new int[6];
    private static final int flowRate = 25;

    public PipeLiquidExtractor(int itemID) {
        super(itemID);
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.worldObj.func_72820_D() % 10L == 0L) {
            return;
        }
        LinkedList connected = this.getConnectedEntities();
        for (AdjacentTile tile : connected) {
            if (!(tile.tile instanceof ITankContainer) || tile.tile instanceof TileGenericPipe) continue;
            this.extractFrom((ITankContainer)tile.tile, tile.orientation);
        }
    }

    private void extractFrom(ITankContainer container, ForgeDirection side) {
        int i = side.ordinal();
        LiquidStack contained = ((PipeLiquidTransportLogistics)this.transport).getTanks(side)[0].getLiquid();
        int amountMissing = ((PipeLiquidTransportLogistics)this.transport).getSideCapacity() - (contained != null ? contained.amount : 0);
        if (this.liquidToExtract[i] < Math.min(200, amountMissing) && this.useEnergy(2)) {
            int n = i;
            this.liquidToExtract[n] = this.liquidToExtract[n] + Math.min(200, amountMissing);
        }
        LiquidStack extracted = container.drain(side.getOpposite(), this.liquidToExtract[i] > 25 ? 25 : this.liquidToExtract[i], false);
        int inserted = 0;
        if (extracted != null) {
            inserted = ((PipeLiquidTransportLogistics)this.transport).fill(side, extracted, true);
            container.drain(side.getOpposite(), inserted, true);
        }
        int n = i;
        this.liquidToExtract[n] = this.liquidToExtract[n] - inserted;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74783_a("liquidToExtract", this.liquidToExtract);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.liquidToExtract = nbttagcompound.func_74759_k("liquidToExtract");
        if (this.liquidToExtract.length < 6) {
            this.liquidToExtract = new int[6];
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_EXTRACTOR;
    }
}

