/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRequestAPI;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logic.TemporaryLogic;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cc.interfaces.CCCommand;
import logisticspipes.proxy.cc.interfaces.CCQueued;
import logisticspipes.proxy.cc.interfaces.CCType;
import logisticspipes.request.RequestHandler;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@CCType(name="LogisticsPipes:Request")
public class PipeItemsRequestLogistics
extends CoreRoutedPipe
implements IRequestItems,
IRequestAPI {
    private final LinkedList _history = new LinkedList();

    public PipeItemsRequestLogistics(int itemID) {
        super(new TemporaryLogic(), itemID);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_REQUESTER_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public void openGui(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 31, this.worldObj, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean wrenchClicked(World world, int i, int j, int k, EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer(world)) {
            if (settings == null || settings.openRequest) {
                this.openGui(entityplayer);
            } else {
                entityplayer.func_70006_a("Permission denied");
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        if (this.worldObj.func_72820_D() % 1200L == 0L) {
            this._history.addLast(SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost()));
            if (this._history.size() > 20) {
                this._history.removeFirst();
            }
        }
    }

    public LinkedList getHistory() {
        return this._history;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public List getProvidedItems() {
        if (this.stillNeedReplace()) {
            return new ArrayList();
        }
        Map items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(items.size());
        for (Map.Entry item : items.entrySet()) {
            ItemStack is = ((ItemIdentifier)item.getKey()).unsafeMakeNormalStack((Integer)item.getValue());
            list.add(is);
        }
        return list;
    }

    @Override
    public List getCraftedItems() {
        if (this.stillNeedReplace()) {
            return new ArrayList();
        }
        LinkedList items = SimpleServiceLocator.logisticsManager.getCraftableItems(this.getRouter().getIRoutersByCost());
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(items.size());
        for (ItemIdentifier item : items) {
            ItemStack is = item.unsafeMakeNormalStack(0);
            list.add(is);
        }
        return list;
    }

    @Override
    public IRequestAPI.SimulationResult simulateRequest(ItemStack wanted) {
        final HashMap used = new HashMap();
        final HashMap missing = new HashMap();
        RequestTree.simulate(ItemIdentifier.get(wanted.field_77993_c, wanted.func_77960_j(), wanted.func_77978_p()).makeStack(wanted.field_77994_a), this, new RequestLog(){

            @Override
            public void handleMissingItems(Map items) {
                for (Map.Entry e : items.entrySet()) {
                    Integer count = (Integer)missing.get(e.getKey());
                    if (count == null) {
                        count = 0;
                    }
                    count = count + (Integer)e.getValue();
                    missing.put(e.getKey(), count);
                }
            }

            @Override
            public void handleSucessfullRequestOf(ItemIdentifier item, int count) {
            }

            @Override
            public void handleSucessfullRequestOfList(Map items) {
                for (Map.Entry e : items.entrySet()) {
                    Integer count = (Integer)used.get(e.getKey());
                    if (count == null) {
                        count = 0;
                    }
                    count = count + (Integer)e.getValue();
                    used.put(e.getKey(), count);
                }
            }
        });
        ArrayList<ItemStack> usedList = new ArrayList<ItemStack>(used.size());
        ArrayList<ItemStack> missingList = new ArrayList<ItemStack>(missing.size());
        for (Map.Entry e : used.entrySet()) {
            usedList.add(((ItemIdentifier)e.getKey()).unsafeMakeNormalStack((Integer)e.getValue()));
        }
        for (Map.Entry e : missing.entrySet()) {
            missingList.add(((ItemIdentifier)e.getKey()).unsafeMakeNormalStack((Integer)e.getValue()));
        }
        IRequestAPI.SimulationResult r = new IRequestAPI.SimulationResult();
        r.used = usedList;
        r.missing = missingList;
        return r;
    }

    @Override
    public List performRequest(ItemStack wanted) {
        final HashMap missing = new HashMap();
        RequestTree.request(ItemIdentifier.get(wanted.field_77993_c, wanted.func_77960_j(), wanted.func_77978_p()).makeStack(wanted.field_77994_a), this, new RequestLog(){

            @Override
            public void handleMissingItems(Map items) {
                for (Map.Entry e : items.entrySet()) {
                    Integer count = (Integer)missing.get(e.getKey());
                    if (count == null) {
                        count = 0;
                    }
                    count = count + (Integer)e.getValue();
                    missing.put(e.getKey(), count);
                }
            }

            @Override
            public void handleSucessfullRequestOf(ItemIdentifier item, int count) {
            }

            @Override
            public void handleSucessfullRequestOfList(Map items) {
            }
        });
        ArrayList<ItemStack> missingList = new ArrayList<ItemStack>(missing.size());
        for (Map.Entry e : missing.entrySet()) {
            missingList.add(((ItemIdentifier)e.getKey()).unsafeMakeNormalStack((Integer)e.getValue()));
        }
        return missingList;
    }

    @CCCommand(description="Requests the given ItemIdentifier Id with the given amount")
    @CCQueued
    public Object[] makeRequest(Double itemId, Double amount) throws Exception {
        return this.makeRequest(itemId, amount, false);
    }

    @CCCommand(description="Requests the given ItemIdentifier Id with the given amount")
    @CCQueued
    public Object[] makeRequest(Double itemId, Double amount, Boolean forceCrafting) throws Exception {
        ItemIdentifier item;
        if (forceCrafting == null) {
            forceCrafting = false;
        }
        if ((item = ItemIdentifier.getForId((int)Math.floor(itemId))) == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        return RequestHandler.computerRequest(item.makeStack((int)Math.floor(amount)), this, forceCrafting);
    }

    @CCCommand(description="Asks for all available ItemIdentifier inside the Logistics Network")
    @CCQueued
    public List getAvailableItems() {
        Map items = SimpleServiceLocator.logisticsManager.getAvailableItems(this.getRouter().getIRoutersByCost());
        LinkedList<Pair> list = new LinkedList<Pair>();
        for (Map.Entry item : items.entrySet()) {
            int amount = (Integer)item.getValue();
            list.add(new Pair(item.getKey(), amount));
        }
        return list;
    }

    @CCCommand(description="Asks for all craftable ItemIdentifier inside the Logistics Network")
    @CCQueued
    public List getCraftableItems() {
        LinkedList items = SimpleServiceLocator.logisticsManager.getCraftableItems(this.getRouter().getIRoutersByCost());
        return items;
    }
}

