/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.logic.TemporaryLogic;
import logisticspipes.logisticspipes.RouteLayer;
import logisticspipes.logisticspipes.RouteLayerFirewall;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.FireWallFlag;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsFirewall
extends CoreRoutedPipe {
    private IRouter[] routers = new IRouter[ForgeDirection.VALID_DIRECTIONS.length];
    private String[] routerIds = new String[ForgeDirection.VALID_DIRECTIONS.length];
    public SimpleInventory inv = new SimpleInventory(36, "Filter Inv", 1);
    private boolean blockProvider = false;
    private boolean blockCrafer = false;
    private boolean blockSorting = false;
    private boolean blockPower = true;
    private boolean isBlocking = true;

    public PipeItemsFirewall(int itemID) {
        super(new TemporaryLogic(), itemID);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public boolean wrenchClicked(World world, int x, int y, int z, EntityPlayer entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer(world)) {
            if (settings == null || settings.openGui) {
                entityplayer.openGui((Object)LogisticsPipes.instance, 17, world, x, y, z);
                MainProxy.sendPacketToPlayer(((FireWallFlag)PacketHandler.getPacket(FireWallFlag.class)).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), (Player)entityplayer);
            } else {
                entityplayer.func_70006_a("Permission denied");
            }
        }
        return true;
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.getRouter(dir).update(this.worldObj.func_72820_D() % (long)Configs.LOGISTICS_DETECTION_FREQUENCY == (long)this._delayOffset || this._initialInit);
        }
    }

    @Override
    public void firstInitialiseTick() {
        super.firstInitialiseTick();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.getRouter(dir);
        }
    }

    @Override
    public void invalidate() {
        for (int i = 0; i < this.routers.length; ++i) {
            if (this.routers[i] == null) continue;
            this.routers[i].destroy();
            this.routers[i] = null;
        }
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        for (int i = 0; i < this.routers.length; ++i) {
            if (this.routers[i] == null) continue;
            this.routers[i].clearPipeCache();
            this.routers[i].clearInterests();
        }
        super.onChunkUnload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRouter getRouter(ForgeDirection dir) {
        if (this.stillNeedReplace) {
            System.out.println("Hey, don't get routers for pipes that aren't ready");
            new Throwable().printStackTrace();
        }
        if (dir.ordinal() < this.routers.length) {
            if (this.routers[dir.ordinal()] == null) {
                Object object = this.routerIdLock;
                synchronized (object) {
                    if (this.routerIds[dir.ordinal()] == null || this.routerIds[dir.ordinal()].isEmpty()) {
                        this.routerIds[dir.ordinal()] = UUID.randomUUID().toString();
                    }
                    this.routers[dir.ordinal()] = SimpleServiceLocator.routerManager.getOrCreateFirewallRouter(UUID.fromString(this.routerIds[dir.ordinal()]), MainProxy.getDimensionForWorld(this.worldObj), this.getX(), this.getY(), this.getZ(), dir);
                }
            }
            return this.routers[dir.ordinal()];
        }
        return super.getRouter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRouter getRouter() {
        if (this.stillNeedReplace) {
            System.out.println("Hey, don't get routers for pipes that aren't ready");
            new Throwable().printStackTrace();
        }
        if (this.router == null) {
            Object object = this.routerIdLock;
            synchronized (object) {
                if (this.routerId == null || this.routerId == "") {
                    this.routerId = UUID.randomUUID().toString();
                }
                this.router = SimpleServiceLocator.routerManager.getOrCreateFirewallRouter(UUID.fromString(this.routerId), MainProxy.getDimensionForWorld(this.worldObj), this.getX(), this.getY(), this.getZ(), ForgeDirection.UNKNOWN);
            }
        }
        return this.router;
    }

    @Override
    public RouteLayer getRouteLayer() {
        if (this._routeLayer == null) {
            this._routeLayer = new RouteLayerFirewall(this.getRouter(), this.getTransportLayer());
        }
        return this._routeLayer;
    }

    public ForgeDirection getRouterSide(IRouter router) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getRouter(dir) != router) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    public boolean isIdforOtherSide(int id) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getRouter(dir).getSimpleID() != id) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            for (int i = 0; i < this.routerIds.length; ++i) {
                nbttagcompound.func_74778_a("routerId" + i, this.routerIds[i]);
            }
        }
        this.inv.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("blockProvider", this.blockProvider);
        nbttagcompound.func_74757_a("blockCrafer", this.blockCrafer);
        nbttagcompound.func_74757_a("blockSorting", this.blockSorting);
        nbttagcompound.func_74757_a("blockPower", this.blockPower);
        nbttagcompound.func_74757_a("isBlocking", this.isBlocking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            for (int i = 0; i < this.routerIds.length; ++i) {
                this.routerIds[i] = nbttagcompound.func_74779_i("routerId" + i);
            }
        }
        this.inv.readFromNBT(nbttagcompound);
        this.blockProvider = nbttagcompound.func_74767_n("blockProvider");
        this.blockCrafer = nbttagcompound.func_74767_n("blockCrafer");
        this.blockSorting = nbttagcompound.func_74767_n("blockSorting");
        if (nbttagcompound.func_74764_b("blockPower")) {
            this.blockPower = nbttagcompound.func_74767_n("blockPower");
        }
        this.isBlocking = nbttagcompound.func_74767_n("isBlocking");
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_FIREWALL_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public List getRouters(IRouter from) {
        ArrayList list = new ArrayList();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.getRouter(dir).equals(from)) continue;
            List nodes = this.getRouter(dir).getIRoutersByCost();
            list.addAll(nodes);
        }
        Collections.sort(list);
        return list;
    }

    public IFilter getFilter(final UUID id, final int simpleid) {
        return new IFilter(){

            @Override
            public boolean isBlocked() {
                return PipeItemsFirewall.this.isBlocking;
            }

            @Override
            public boolean isFilteredItem(ItemIdentifier item) {
                return PipeItemsFirewall.this.inv.containsUndamagedItem(item);
            }

            @Override
            public boolean blockProvider() {
                return PipeItemsFirewall.this.blockProvider;
            }

            @Override
            public boolean blockCrafting() {
                return PipeItemsFirewall.this.blockCrafer;
            }

            @Override
            public UUID getUUID() {
                return id;
            }

            @Override
            public int getSimpleID() {
                return simpleid;
            }

            @Override
            public boolean blockRouting() {
                return PipeItemsFirewall.this.blockSorting;
            }

            @Override
            public boolean blockPower() {
                return PipeItemsFirewall.this.blockPower;
            }
        };
    }

    public boolean isBlockProvider() {
        return this.blockProvider;
    }

    public void setBlockProvider(boolean blockProvider) {
        this.blockProvider = blockProvider;
        MainProxy.sendPacketToServer(((FireWallFlag)PacketHandler.getPacket(FireWallFlag.class)).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlockCrafer() {
        return this.blockCrafer;
    }

    public void setBlockCrafer(boolean blockCrafer) {
        this.blockCrafer = blockCrafer;
        MainProxy.sendPacketToServer(((FireWallFlag)PacketHandler.getPacket(FireWallFlag.class)).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlockSorting() {
        return this.blockSorting;
    }

    public void setBlockSorting(boolean blockSorting) {
        this.blockSorting = blockSorting;
        MainProxy.sendPacketToServer(((FireWallFlag)PacketHandler.getPacket(FireWallFlag.class)).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlockPower() {
        return this.blockPower;
    }

    public void setBlockPower(boolean blockPower) {
        this.blockPower = blockPower;
        MainProxy.sendPacketToServer(((FireWallFlag)PacketHandler.getPacket(FireWallFlag.class)).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
        MainProxy.sendPacketToServer(((FireWallFlag)PacketHandler.getPacket(FireWallFlag.class)).setFlags(this.getFlags()).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    private BitSet getFlags() {
        BitSet flags = new BitSet();
        flags.set(0, this.blockProvider);
        flags.set(1, this.blockCrafer);
        flags.set(2, this.blockSorting);
        flags.set(3, this.blockPower);
        flags.set(4, this.isBlocking);
        return flags;
    }

    public void setFlags(BitSet flags) {
        this.blockProvider = flags.get(0);
        this.blockCrafer = flags.get(1);
        this.blockSorting = flags.get(2);
        this.blockPower = flags.get(3);
        this.isBlocking = flags.get(4);
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    protected void addRouterCrashReport(CrashReportCategory crashReportCategory) {
        for (int i = 0; i < 7; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            crashReportCategory.func_71507_a("Router (" + dir.toString() + ")", (Object)this.getRouter(dir));
        }
    }
}

