/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.crafting.AutoCraftingInventory;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.PipeTransportLayer;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.RoutedEntityItem;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.utils.CraftingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PipeBlockRequestTable
extends PipeItemsRequestLogistics
implements ISimpleInventoryEventHandler {
    public SimpleInventory inv = new SimpleInventory(27, "Crafting Resources", 64);
    public SimpleInventory matrix = new SimpleInventory(9, "Crafting Matrix", 1);
    public SimpleInventory resultInv = new SimpleInventory(1, "Crafting Result", 1);
    public SimpleInventory toSortInv = new SimpleInventory(1, "Sorting Slot", 64);
    private IRecipe cache;
    private EntityPlayer fake;
    private int delay = 0;

    public PipeBlockRequestTable(int itemID) {
        super(itemID);
        this.matrix.addListener(this);
    }

    @Override
    public boolean handleClick(World world, int i, int j, int k, EntityPlayer entityplayer, SecuritySettings settings) {
        if (SimpleServiceLocator.buildCraftProxy.isUpgradeManagerEquipped(entityplayer) && !entityplayer.func_70093_af()) {
            return false;
        }
        if (MainProxy.isServer(world)) {
            if (settings == null || settings.openGui) {
                this.openGui(entityplayer);
            } else {
                entityplayer.func_70006_a("Permission denied");
            }
        }
        return true;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        ItemStack stack = this.toSortInv.func_70301_a(0);
        if (stack != null) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
            SimpleServiceLocator.logisticsManager.assignDestinationFor(itemToSend, this.getRouter().getSimpleID(), false);
            if (itemToSend.getDestinationUUID() != null) {
                ForgeDirection dir = this.getRouteLayer().getOrientationForItem(itemToSend, null);
                super.queueRoutedItem(itemToSend, dir.getOpposite());
                MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this.worldObj, 4);
                this.toSortInv.func_70299_a(0, null);
            } else {
                this.delay = 100;
            }
        } else {
            this.delay = 0;
        }
    }

    @Override
    public void openGui(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 38, this.worldObj, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.empty;
    }

    @Override
    public Textures.TextureType getRoutedTexture(ForgeDirection connection) {
        return Textures.empty_1;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        return Textures.empty_2;
    }

    public Icon getTextureFor(int l) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)l);
        switch (dir) {
            case UP: {
                return Textures.LOGISTICS_REQUEST_TABLE[0];
            }
            case DOWN: {
                return Textures.LOGISTICS_REQUEST_TABLE[1];
            }
        }
        if (this.container.getRenderState().pipeConnectionMatrix.isConnected(dir)) {
            if (this.container.getRenderState().textureMatrix.getTextureIndex(dir) == 1) {
                return Textures.LOGISTICS_REQUEST_TABLE[2];
            }
            return Textures.LOGISTICS_REQUEST_TABLE[3];
        }
        return Textures.LOGISTICS_REQUEST_TABLE[4];
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        if (MainProxy.isServer(this.worldObj)) {
            this.inv.dropContents(this.getWorld(), this.getX(), this.getY(), this.getZ());
        }
    }

    public void cacheRecipe() {
        this.cache = null;
        this.resultInv.func_70299_a(0, null);
        AutoCraftingInventory craftInv = new AutoCraftingInventory();
        for (int i = 0; i < 9; ++i) {
            craftInv.func_70299_a(i, this.matrix.func_70301_a(i));
        }
        for (IRecipe r : CraftingUtil.getRecipeList()) {
            if (!r.func_77569_a((InventoryCrafting)craftInv, this.worldObj)) continue;
            this.cache = r;
            this.resultInv.func_70299_a(0, r.func_77572_b((InventoryCrafting)craftInv));
        }
    }

    public ItemStack getOutput() {
        ItemStack left;
        int i;
        int j;
        if (this.cache == null) {
            this.cacheRecipe();
            if (this.cache == null) {
                return null;
            }
        }
        int[] toUse = new int[9];
        int[] used = new int[this.inv.func_70302_i_()];
        block0: for (int i2 = 0; i2 < 9; ++i2) {
            ItemStack item = this.matrix.func_70301_a(i2);
            if (item == null) {
                toUse[i2] = -1;
                continue;
            }
            ItemIdentifier ident = ItemIdentifier.get(item);
            for (j = 0; j < this.inv.func_70302_i_(); ++j) {
                item = this.inv.func_70301_a(j);
                if (item == null || !ident.equalsForCrafting(ItemIdentifier.get(item)) || item.field_77994_a <= used[j]) continue;
                int n = j;
                used[n] = used[n] + 1;
                toUse[i2] = j;
                continue block0;
            }
            return null;
        }
        AutoCraftingInventory crafter = new AutoCraftingInventory();
        for (int i3 = 0; i3 < 9; ++i3) {
            int j2 = toUse[i3];
            if (j2 == -1) continue;
            crafter.func_70299_a(i3, this.inv.func_70301_a(j2));
        }
        ItemStack result = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (result == null) {
            return null;
        }
        if (!ItemIdentifier.get(this.resultInv.func_70301_a(0)).equalsWithoutNBT(ItemIdentifier.get(result))) {
            return null;
        }
        crafter = new AutoCraftingInventory();
        for (int i4 = 0; i4 < 9; ++i4) {
            j = toUse[i4];
            if (j == -1) continue;
            crafter.func_70299_a(i4, this.inv.func_70298_a(j, 1));
        }
        result = this.cache.func_77572_b((InventoryCrafting)crafter);
        if (this.fake == null) {
            this.fake = MainProxy.getFakePlayer((TileEntity)this.container);
        }
        result = result.func_77946_l();
        SlotCrafting craftingSlot = new SlotCrafting(this.fake, (IInventory)crafter, (IInventory)this.resultInv, 0, 0, 0);
        craftingSlot.func_82870_a(this.fake, result);
        for (i = 0; i < 9; ++i) {
            left = crafter.func_70301_a(i);
            crafter.func_70299_a(i, null);
            if (left == null) continue;
            this.inv.addCompressed(left);
        }
        for (i = 0; i < this.fake.field_71071_by.func_70302_i_(); ++i) {
            left = this.fake.field_71071_by.func_70301_a(i);
            this.fake.field_71071_by.func_70299_a(i, null);
            if (left == null) continue;
            this.inv.addCompressed(left);
        }
        return result;
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        if (inventory == this.matrix) {
            this.cacheRecipe();
        }
    }

    public void handleNEIRecipePacket(ItemStack[] content) {
        for (int i = 0; i < 9; ++i) {
            this.matrix.func_70299_a(i, content[i]);
        }
        this.cacheRecipe();
    }

    @Override
    public void readFromNBT(NBTTagCompound par1nbtTagCompound) {
        super.readFromNBT(par1nbtTagCompound);
        this.inv.readFromNBT(par1nbtTagCompound, "inv");
        this.matrix.readFromNBT(par1nbtTagCompound, "matrix");
        this.toSortInv.readFromNBT(par1nbtTagCompound, "toSortInv");
        this.cacheRecipe();
    }

    @Override
    public void writeToNBT(NBTTagCompound par1nbtTagCompound) {
        super.writeToNBT(par1nbtTagCompound);
        this.inv.writeToNBT(par1nbtTagCompound, "inv");
        this.matrix.writeToNBT(par1nbtTagCompound, "matrix");
        this.toSortInv.writeToNBT(par1nbtTagCompound, "toSortInv");
    }

    @Override
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new PipeTransportLayer(this, this, this.getRouter()){

                @Override
                public ForgeDirection itemArrived(IRoutedItem item, ForgeDirection denyed) {
                    if (item.getItemStack() != null) {
                        ItemStack stack = item.getItemStack();
                        stack.field_77994_a = PipeBlockRequestTable.this.inv.addCompressed(stack);
                        item.setItemStack(stack);
                        if (stack.field_77994_a == 0) {
                            PipeBlockRequestTable.this.notifyOfItemArival((RoutedEntityItem)item);
                            return null;
                        }
                    }
                    return super.itemArrived(item, denyed);
                }
            };
        }
        return super.getTransportLayer();
    }
}

