/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.LaserData;
import net.minecraft.entity.player.EntityPlayer;

public class RoutingLaserPacket
extends ModernPacket {
    List lasers = new ArrayList();

    public RoutingLaserPacket(int id) {
        super(id);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        while (data.readBoolean()) {
            this.lasers.add(new LaserData().readData(data));
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsHUDRenderer.instance().setLasers(this.getLasers());
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        for (LaserData laser : this.lasers) {
            data.writeBoolean(true);
            laser.writeData(data);
        }
        data.writeBoolean(false);
    }

    @Override
    public ModernPacket template() {
        return new RoutingLaserPacket(this.getId());
    }

    public RoutingLaserPacket setLasers(List lasers) {
        this.lasers = lasers;
        return this;
    }

    public List getLasers() {
        return this.lasers;
    }
}

