/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import buildcraft.api.core.Position;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import logisticspipes.config.Configs;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.RoutingLaserPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IPaintPath;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LaserData;
import logisticspipes.routing.PathFinder;
import logisticspipes.routing.PipeRoutingConnectionType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class RequestRoutingLasersPacket
extends CoordinatesPacket {
    private boolean firstPipe = false;

    public RequestRoutingLasersPacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileGenericPipe tile = this.getPipe(player.field_70170_p);
        if (tile == null) {
            return;
        }
        if (tile.pipe instanceof CoreRoutedPipe) {
            IRouter router = ((CoreRoutedPipe)tile.pipe).getRouter();
            ArrayList exits = router.getRouteTable();
            HashMap routers = new HashMap();
            for (ExitRoute exit : exits) {
                if (exit == null) continue;
                if (!routers.containsKey(exit.exitOrientation)) {
                    routers.put(exit.exitOrientation, new ArrayList());
                }
                ((ArrayList)routers.get(exit.exitOrientation)).add(exit.destination);
            }
            ArrayList lasers = new ArrayList();
            this.firstPipe = true;
            for (ForgeDirection dir : routers.keySet()) {
                this.handleRouteInDirection(tile, dir, (ArrayList)routers.get(dir), lasers, EnumSet.allOf(PipeRoutingConnectionType.class));
            }
            lasers = this.compressLasers(lasers);
            MainProxy.sendPacketToPlayer(((RoutingLaserPacket)PacketHandler.getPacket(RoutingLaserPacket.class)).setLasers(lasers), (Player)player);
        }
    }

    private void handleRouteInDirection(final TileGenericPipe pipe, ForgeDirection dir, ArrayList connectedRouters, final List lasers, EnumSet connectionType) {
        lasers.add(new LaserData(pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, dir, connectionType).setStartPipe(this.firstPipe));
        this.firstPipe = false;
        HashMap map = PathFinder.paintAndgetConnectedRoutingPipes(pipe, dir, Configs.LOGISTICS_DETECTION_COUNT, Configs.LOGISTICS_DETECTION_LENGTH, new IPaintPath(){

            @Override
            public void addLaser(World worldObj, LaserData laser) {
                if (pipe.field_70331_k == worldObj) {
                    lasers.add(laser);
                }
            }
        }, connectionType);
        for (CoreRoutedPipe connectedPipe : map.keySet()) {
            IRouter newRouter = connectedPipe.getRouter(((ExitRoute)map.get((Object)connectedPipe)).insertOrientation);
            connectedRouters.remove(newRouter);
            HashMap routers = new HashMap();
            Iterator iRouter = connectedRouters.iterator();
            while (iRouter.hasNext()) {
                IRouter router = (IRouter)iRouter.next();
                ExitRoute exit = newRouter.getDistanceTo(router);
                if (exit == null || exit.exitOrientation.equals((Object)((ExitRoute)map.get((Object)connectedPipe)).insertOrientation)) continue;
                iRouter.remove();
                if (!routers.containsKey(exit.exitOrientation)) {
                    routers.put(exit.exitOrientation, new ArrayList());
                }
                ((ArrayList)routers.get(exit.exitOrientation)).add(exit.destination);
            }
            for (ForgeDirection exitDir : routers.keySet()) {
                this.handleRouteInDirection(connectedPipe.container, exitDir, (ArrayList)routers.get(exitDir), lasers, ((ExitRoute)map.get((Object)connectedPipe)).connectionDetails);
            }
        }
    }

    private ArrayList compressLasers(ArrayList lasers) {
        ArrayList options = new ArrayList();
        options.addAll(lasers);
        Iterator iLasers = lasers.iterator();
        while (iLasers.hasNext()) {
            boolean compressed = false;
            LaserData data = (LaserData)iLasers.next();
            Position next = new Position((double)data.getPosX(), (double)data.getPosY(), (double)data.getPosZ(), data.getDir());
            next.moveForwards((double)data.getLength());
            boolean found = false;
            do {
                found = false;
                Iterator iOptions = options.iterator();
                while (iOptions.hasNext()) {
                    LaserData d = (LaserData)iOptions.next();
                    if (d.getPosX() != (int)next.x || d.getPosY() != (int)next.y || d.getPosZ() != (int)next.z) continue;
                    if (data.getDir().equals((Object)d.getDir()) && data.getConnectionType().equals(d.getConnectionType())) {
                        data.setLength(data.getLength() + d.getLength());
                        next.moveForwards((double)d.getLength());
                        found = true;
                        iOptions.remove();
                        lasers.remove(d);
                        compressed = true;
                        continue;
                    }
                    if (!data.getDir().equals((Object)d.getDir())) continue;
                    data.setFinalPipe(false);
                }
            } while (found);
            if (!compressed) continue;
            iLasers = lasers.iterator();
        }
        return lasers;
    }

    @Override
    public ModernPacket template() {
        return new RequestRoutingLasersPacket(this.getId());
    }
}

