/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.PacketPayload;
import logisticspipes.network.TilePacketWrapper;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import net.minecraft.entity.player.EntityPlayer;

public class PipeUpdate
extends CoordinatesPacket {
    private PacketPayload payload;

    public PipeUpdate(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new PipeUpdate(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileGenericPipe tile = this.getPipe(player.field_70170_p);
        if (tile == null) {
            return;
        }
        if (tile.pipe == null) {
            return;
        }
        new TilePacketWrapper(new Class[]{TileGenericPipe.class, tile.pipe.transport.getClass(), tile.pipe.logic.getClass()}).fromPayload(new Object[]{tile.pipe.container, tile.pipe.transport, tile.pipe.logic}, this.getPayload());
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.intPayload.length);
        data.writeInt(this.payload.floatPayload.length);
        data.writeInt(this.payload.stringPayload.length);
        for (int intData : this.payload.intPayload) {
            data.writeInt(intData);
        }
        for (float floatData : this.payload.floatPayload) {
            data.writeFloat(floatData);
        }
        for (String stringData : this.payload.stringPayload) {
            data.writeUTF(stringData);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int i;
        super.readData(data);
        this.payload = new PacketPayload();
        this.payload.intPayload = new int[data.readInt()];
        this.payload.floatPayload = new float[data.readInt()];
        this.payload.stringPayload = new String[data.readInt()];
        for (i = 0; i < this.payload.intPayload.length; ++i) {
            this.payload.intPayload[i] = data.readInt();
        }
        for (i = 0; i < this.payload.floatPayload.length; ++i) {
            this.payload.floatPayload[i] = data.readFloat();
        }
        for (i = 0; i < this.payload.stringPayload.length; ++i) {
            this.payload.stringPayload[i] = data.readUTF();
        }
    }

    public PacketPayload getPayload() {
        return this.payload;
    }

    public PipeUpdate setPayload(PacketPayload payload) {
        this.payload = payload;
        return this;
    }
}

