/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import logisticspipes.network.BitSetHelper;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidUpdate
extends CoordinatesPacket {
    private LiquidStack[] renderCache = new LiquidStack[ForgeDirection.values().length];
    private BitSet delta;
    private DataInputStream dataStream;

    public PipeLiquidUpdate(int id) {
        super(id);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.delta = BitSetHelper.read(data);
        this.setDataStream(data);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        BitSetHelper.write(data, this.delta);
        for (ForgeDirection dir : ForgeDirection.values()) {
            LiquidStack liquid = this.renderCache[dir.ordinal()];
            if (this.delta.get(dir.ordinal() * 3 + 0)) {
                if (liquid != null) {
                    data.writeShort(liquid.itemID);
                } else {
                    data.writeShort(0);
                }
            }
            if (this.delta.get(dir.ordinal() * 3 + 1)) {
                if (liquid != null) {
                    data.writeShort(liquid.itemMeta);
                } else {
                    data.writeShort(0);
                }
            }
            if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
            if (liquid != null) {
                data.writeShort(liquid.amount);
                continue;
            }
            data.writeShort(0);
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileGenericPipe pipe = this.getPipe(player.field_70170_p);
        if (pipe == null || pipe.pipe == null) {
            return;
        }
        if (!(pipe.pipe.transport instanceof PipeLiquidTransportLogistics)) {
            return;
        }
        this.renderCache = ((PipeLiquidTransportLogistics)pipe.pipe.transport).renderCache;
        try {
            for (ForgeDirection dir : ForgeDirection.values()) {
                if (this.renderCache[dir.ordinal()] == null) {
                    this.renderCache[dir.ordinal()] = new LiquidStack(0, 0, 0);
                }
                if (this.delta.get(dir.ordinal() * 3 + 0)) {
                    this.renderCache[dir.ordinal()] = new LiquidStack((int)this.getDataStream().readShort(), this.renderCache[dir.ordinal()].amount);
                }
                if (this.delta.get(dir.ordinal() * 3 + 1)) {
                    this.renderCache[dir.ordinal()] = new LiquidStack(this.renderCache[dir.ordinal()].itemID, this.renderCache[dir.ordinal()].amount, (int)this.getDataStream().readShort());
                }
                if (!this.delta.get(dir.ordinal() * 3 + 2)) continue;
                this.renderCache[dir.ordinal()].amount = dir != ForgeDirection.UNKNOWN ? Math.min(((PipeLiquidTransportLogistics)pipe.pipe.transport).getSideCapacity(), this.getDataStream().readShort()) : Math.min(((PipeLiquidTransportLogistics)pipe.pipe.transport).getInnerCapacity(), this.getDataStream().readShort());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ModernPacket template() {
        return new PipeLiquidUpdate(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    private LiquidStack[] getRenderCache() {
        return this.renderCache;
    }

    public PipeLiquidUpdate setRenderCache(LiquidStack[] renderCache) {
        this.renderCache = renderCache;
        return this;
    }

    private BitSet getDelta() {
        return this.delta;
    }

    public PipeLiquidUpdate setDelta(BitSet delta) {
        this.delta = delta;
        return this;
    }

    private DataInputStream getDataStream() {
        return this.dataStream;
    }

    private PipeLiquidUpdate setDataStream(DataInputStream dataStream) {
        this.dataStream = dataStream;
        return this;
    }
}

