/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.modules;

import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.modules.ModuleApiaristSink;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.NBTCoordinatesPacket;
import logisticspipes.pipes.PipeItemsApiaristSink;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import net.minecraft.entity.player.EntityPlayer;

public class BeeModule
extends NBTCoordinatesPacket {
    private int slot;

    public BeeModule(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new BeeModule(this.getId());
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.slot);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.slot = data.readInt();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ModuleApiaristSink sink;
        TileGenericPipe tile = this.getPipe(player.field_70170_p);
        if (tile == null) {
            return;
        }
        if (this.getSlot() == -1 && tile.pipe instanceof PipeItemsApiaristSink) {
            sink = (ModuleApiaristSink)((PipeItemsApiaristSink)tile.pipe).getLogisticsModule();
        } else if (tile.pipe instanceof CoreRoutedPipe && ((CoreRoutedPipe)tile.pipe).getLogisticsModule().getSubModule(this.getSlot()) instanceof ModuleApiaristSink) {
            sink = (ModuleApiaristSink)((CoreRoutedPipe)tile.pipe).getLogisticsModule().getSubModule(this.getSlot());
        } else {
            return;
        }
        if (this.getTag() != null) {
            sink.readFromPacketNBT(this.getTag());
        }
    }

    public BeeModule setSlot(int slot) {
        this.slot = slot;
        return this;
    }

    public int getSlot() {
        return this.slot;
    }
}

