/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.ticks.DebugGuiTickHandler;
import net.minecraft.entity.player.EntityPlayer;

public class DebugTargetResponse
extends ModernPacket {
    private TargetMode mode;
    private Object[] additions = new Object[0];

    public DebugTargetResponse(int id) {
        super(id);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.mode = TargetMode.values()[data.readByte()];
        int size = data.readInt();
        this.additions = new Object[size];
        for (int i = 0; i < size; ++i) {
            int arraySize = data.readInt();
            byte[] bytes = new byte[arraySize];
            data.read(bytes);
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream in = null;
            in = new ObjectInputStream(bis);
            try {
                Object o;
                this.additions[i] = o = in.readObject();
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        DebugGuiTickHandler.instance().targetResponse(this.mode, player, this.additions);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.mode.ordinal());
        data.writeInt(this.additions.length);
        for (int i = 0; i < this.additions.length; ++i) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            out = new ObjectOutputStream(bos);
            out.writeObject(this.additions[i]);
            byte[] bytes = bos.toByteArray();
            data.writeInt(bytes.length);
            data.write(bytes);
        }
    }

    @Override
    public ModernPacket template() {
        return new DebugTargetResponse(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public TargetMode getMode() {
        return this.mode;
    }

    public DebugTargetResponse setMode(TargetMode mode) {
        this.mode = mode;
        return this;
    }

    public Object[] getAdditions() {
        return this.additions;
    }

    public DebugTargetResponse setAdditions(Object[] additions) {
        this.additions = additions;
        return this;
    }

    public static enum TargetMode {
        Block,
        Entity,
        None;

    }
}

