/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.ticks.DebugGuiTickHandler;
import net.minecraft.entity.player.EntityPlayer;

public class DebugInfoUpdate
extends ModernPacket {
    private Integer[] path;
    private DebugGuiTickHandler.VarType information;

    public DebugInfoUpdate(int id) {
        super(id);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int arraySize = data.readInt();
        byte[] bytes = new byte[arraySize];
        data.read(bytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = null;
        in = new ObjectInputStream(bis);
        try {
            this.information = (DebugGuiTickHandler.VarType)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException(e);
        }
        int size = data.readInt();
        this.path = new Integer[size];
        for (int i = 0; i < size; ++i) {
            this.path[i] = data.readInt();
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        try {
            DebugGuiTickHandler.instance().handleContentUpdatePacket(this.path, this.getInformation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(this.getInformation());
        byte[] bytes = bos.toByteArray();
        data.writeInt(bytes.length);
        data.write(bytes);
        data.writeInt(this.path.length);
        for (int i = 0; i < this.path.length; ++i) {
            data.writeInt(this.path[i]);
        }
    }

    @Override
    public ModernPacket template() {
        return new DebugInfoUpdate(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public Integer[] getPath() {
        return this.path;
    }

    public DebugInfoUpdate setPath(Integer[] path) {
        this.path = path;
        return this;
    }

    public DebugGuiTickHandler.VarType getInformation() {
        return this.information;
    }

    public DebugInfoUpdate setInformation(DebugGuiTickHandler.VarType information) {
        this.information = information;
        return this;
    }
}

