/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debuggui;

import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.ticks.DebugGuiTickHandler;
import net.minecraft.entity.player.EntityPlayer;

public class DebugExpandPart
extends ModernPacket {
    public Integer[] tree;

    public DebugExpandPart(int id) {
        super(id);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int size = data.readInt();
        this.tree = new Integer[size];
        for (int i = 0; i < size; ++i) {
            this.tree[i] = data.readInt();
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        try {
            DebugGuiTickHandler.instance().expandGuiAt(this.tree, (Player)player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.tree.length);
        for (int i = 0; i < this.tree.length; ++i) {
            data.writeInt(this.tree[i]);
        }
    }

    @Override
    public ModernPacket template() {
        return new DebugExpandPart(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public Integer[] getTree() {
        return this.tree;
    }

    public DebugExpandPart setTree(Integer[] tree) {
        this.tree = tree;
        return this;
    }
}

