/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.orderer.RequestSubmitPacket;
import logisticspipes.utils.ItemIdentifierStack;

public abstract class RequestPacket
extends CoordinatesPacket {
    private ItemIdentifierStack stack;
    private int dimension;

    public RequestPacket(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new RequestSubmitPacket(this.getId());
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        this.stack.write(data);
        data.writeInt(this.dimension);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.stack = ItemIdentifierStack.read(data);
        this.dimension = data.readInt();
    }

    public ItemIdentifierStack getStack() {
        return this.stack;
    }

    public RequestPacket setStack(ItemIdentifierStack stack) {
        this.stack = stack;
        return this;
    }

    public int getDimension() {
        return this.dimension;
    }

    public RequestPacket setDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }
}

