/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet250CustomPayload;

public abstract class ModernPacket {
    private boolean isChunkDataPacket;
    private boolean compressable;
    protected String channel = "BCLP";
    private final int id;
    private byte[] data = null;

    public ModernPacket(int id) {
        this.id = id;
    }

    public Packet250CustomPayload getPacket() {
        if (this.data == null) {
            throw new RuntimeException("The packet needs to be created() first;");
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = this.channel;
        packet.field_73629_c = this.data;
        packet.field_73628_b = packet.field_73629_c.length;
        packet.field_73287_r = this.isChunkDataPacket();
        return packet;
    }

    public void create() {
        if (this.data != null) {
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(bytes);
        try {
            dataStream.writeInt(this.getId());
            this.writeData(dataStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.data = bytes.toByteArray();
    }

    public abstract void readData(DataInputStream var1) throws IOException;

    public abstract void processPacket(EntityPlayer var1);

    public abstract void writeData(DataOutputStream var1) throws IOException;

    public abstract ModernPacket template();

    public boolean isChunkDataPacket() {
        return this.isChunkDataPacket;
    }

    public ModernPacket setChunkDataPacket(boolean isChunkDataPacket) {
        this.isChunkDataPacket = isChunkDataPacket;
        return this;
    }

    public boolean isCompressable() {
        return this.compressable;
    }

    public ModernPacket setCompressable(boolean compressable) {
        this.compressable = compressable;
        return this;
    }

    public String getChannel() {
        return this.channel;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }
}

