/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import logisticspipes.network.SendNBTTagCompound;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class InventoryCoordinatesPacket
extends CoordinatesPacket {
    private IInventory inventory;
    private List stackList;
    private List identList;
    private Set identSet;

    public InventoryCoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.inventory != null) {
            data.writeByte(0);
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                data.writeByte(i);
                this.sendItemStack(this.inventory.func_70301_a(i), data);
            }
            data.writeByte(-1);
        } else if (this.stackList != null) {
            data.writeByte(0);
            for (int i = 0; i < this.stackList.size(); ++i) {
                data.writeByte(i);
                this.sendItemStack((ItemStack)this.stackList.get(i), data);
            }
            data.writeByte(-1);
        } else if (this.identList != null) {
            data.writeByte(1);
            for (ItemIdentifierStack stack : this.identList) {
                data.writeByte(1);
                this.sendItemIdentifierStack(stack, data);
            }
            data.writeByte(-1);
        } else if (this.identSet != null) {
            data.writeByte(1);
            for (ItemIdentifierStack stack : this.identSet) {
                data.writeByte(1);
                this.sendItemIdentifierStack(stack, data);
            }
            data.writeByte(-1);
        } else {
            throw new UnsupportedOperationException("Can't send this Packet without content");
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        byte mode = data.readByte();
        if (mode == 0) {
            this.stackList = new LinkedList();
            byte index = data.readByte();
            while (index != -1) {
                ((LinkedList)this.stackList).addLast(this.readItemStack(data));
                index = data.readByte();
            }
        } else if (mode == 1) {
            this.identList = new LinkedList();
            byte index = data.readByte();
            while (index != -1) {
                ((LinkedList)this.identList).addLast(this.readItemIdentifierStack(data));
                index = data.readByte();
            }
        } else {
            throw new UnsupportedOperationException("Unknown receive mode: " + mode);
        }
    }

    private void sendItemStack(ItemStack itemstack, DataOutputStream data) throws IOException {
        if (itemstack != null) {
            data.writeInt(itemstack.field_77993_c);
            data.writeInt(itemstack.field_77994_a);
            data.writeInt(itemstack.func_77960_j());
            SendNBTTagCompound.writeNBTTagCompound(itemstack.func_77978_p(), data);
        } else {
            data.writeInt(0);
        }
    }

    private void sendItemIdentifierStack(ItemIdentifierStack item, DataOutputStream data) throws IOException {
        if (item != null) {
            item.write(data);
        } else {
            data.writeInt(0);
        }
    }

    private ItemStack readItemStack(DataInputStream data) throws IOException {
        int itemID = data.readInt();
        if (itemID == 0) {
            return null;
        }
        int stackSize = data.readInt();
        int damage = data.readInt();
        ItemStack stack = new ItemStack(itemID, stackSize, damage);
        stack.func_77982_d(SendNBTTagCompound.readNBTTagCompound(data));
        return stack;
    }

    private ItemIdentifierStack readItemIdentifierStack(DataInputStream data) throws IOException {
        int itemID = data.readInt();
        if (itemID == 0) {
            return null;
        }
        int stackSize = data.readInt();
        int damage = data.readInt();
        NBTTagCompound tag = SendNBTTagCompound.readNBTTagCompound(data);
        return new ItemIdentifierStack(ItemIdentifier.get(itemID, damage, tag), stackSize);
    }

    public InventoryCoordinatesPacket setInventory(IInventory inventory) {
        this.inventory = inventory;
        return this;
    }

    public List getStackList() {
        return this.stackList;
    }

    public InventoryCoordinatesPacket setStackList(List stackList) {
        this.stackList = stackList;
        return this;
    }

    public List getIdentList() {
        return this.identList;
    }

    public InventoryCoordinatesPacket setIdentList(List identList) {
        this.identList = identList;
        return this;
    }

    public InventoryCoordinatesPacket setIdentSet(Set identSet) {
        this.identSet = identSet;
        return this;
    }
}

