/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import buildcraft.transport.TileGenericPipe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.LogisticsPipes;
import logisticspipes.network.abstractpackets.ModernPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class CoordinatesPacket
extends ModernPacket {
    private int posX;
    private int posY;
    private int posZ;

    public CoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
    }

    public Object getTile(World world, Class clazz) {
        if (world == null) {
            return null;
        }
        if (!world.func_72899_e(this.getPosX(), this.getPosY(), this.getPosZ())) {
            if (LogisticsPipes.DEBUG) {
                LogisticsPipes.log.severe(this.toString());
                new RuntimeException("Couldn't find " + clazz.getName()).printStackTrace();
            }
            return null;
        }
        TileEntity tile = world.func_72796_p(this.getPosX(), this.getPosY(), this.getPosZ());
        if (tile != null) {
            if (!clazz.isAssignableFrom(tile.getClass())) {
                if (LogisticsPipes.DEBUG) {
                    LogisticsPipes.log.severe(this.toString());
                    new RuntimeException("Couldn't find " + clazz.getName() + ", found " + tile.getClass()).printStackTrace();
                }
                return null;
            }
        } else if (LogisticsPipes.DEBUG) {
            LogisticsPipes.log.severe(this.toString());
            new RuntimeException("Couldn't find " + clazz.getName()).printStackTrace();
        }
        return tile;
    }

    public TileGenericPipe getPipe(World world) {
        return (TileGenericPipe)this.getTile(world, TileGenericPipe.class);
    }

    public String toString() {
        return "CoordinatesPacket(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ")";
    }

    public int getPosX() {
        return this.posX;
    }

    public CoordinatesPacket setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public CoordinatesPacket setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public CoordinatesPacket setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }
}

