/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsGuiModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.module.ThaumicAspectsSinkList;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleThaumicAspectSink
extends LogisticsGuiModule
implements IClientInformationProvider,
IModuleWatchReciver {
    private int slot = 0;
    private IRoutedPowerProvider _power;
    private IWorldProvider _world;
    public final List aspectList = new LinkedList();
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, -2, true, false, 5, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerProvider) {
        this._power = powerProvider;
        this._world = world;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._power.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._power.getY();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._power.getZ();
        }
        return -1 - this.slot;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > ModuleThaumicAspectSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleThaumicAspectSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleThaumicAspectSink._sinkReply.customPriority) {
            return null;
        }
        if (this.isOfInterest(item)) {
            return _sinkReply;
        }
        return null;
    }

    private boolean isOfInterest(ItemIdentifier itemID) {
        if (itemID == null || this.aspectList.size() == 0) {
            return false;
        }
        ItemStack item = itemID.makeNormalStack(1);
        List itemAspectList = SimpleServiceLocator.thaumCraftProxy.getListOfTagIDsForStack(item);
        if (itemAspectList.size() == 0 || itemAspectList == null) {
            return false;
        }
        for (int i = 0; i < itemAspectList.size(); ++i) {
            if (!this.aspectList.contains(itemAspectList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.aspectList.clear();
        int size = nbttagcompound.func_74762_e("aspectListSize");
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.aspectList.add(nbttagcompound.func_74762_e("aspect" + i));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("aspectListSize", this.aspectList.size());
        if (this.aspectList.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.aspectList.size(); ++i) {
            nbttagcompound.func_74768_a("aspect" + i, ((Integer)this.aspectList.get(i)).intValue());
        }
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(((ThaumicAspectsSinkList)PacketHandler.getPacket(ThaumicAspectsSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), (Player)player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    public void aspectListChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList(((ThaumicAspectsSinkList)PacketHandler.getPacket(ThaumicAspectsSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(((ThaumicAspectsSinkList)PacketHandler.getPacket(ThaumicAspectsSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
        }
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Aspects: ");
        if (this.aspectList.size() == 0) {
            info.add("none");
        }
        for (int i = 0; i < this.aspectList.size(); ++i) {
            info.add(" - " + SimpleServiceLocator.thaumCraftProxy.getNameForTagID((Integer)this.aspectList.get(i)));
        }
        return info;
    }

    @Override
    public int getGuiHandlerID() {
        return 41;
    }

    public void handleItem(ItemStack stack) {
        List itemAspectList = SimpleServiceLocator.thaumCraftProxy.getListOfTagIDsForStack(stack);
        if (itemAspectList == null) {
            return;
        }
        boolean listChanged = false;
        for (int i = 0; i < itemAspectList.size(); ++i) {
            if (this.aspectList.contains(itemAspectList.get(i)) || this.aspectList.size() >= 9) continue;
            this.aspectList.add(itemAspectList.get(i));
            listChanged = true;
        }
        if (listChanged) {
            this.aspectListChanged();
        }
    }

    public void clearAspectList() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.readFromNBT(nbt);
        this.aspectListChanged();
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleThaumicAspectSink");
    }
}

