/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleQuickSort
extends LogisticsModule {
    private final int stalledDelay = 24;
    private final int normalDelay = 6;
    private int currentTick = 0;
    private boolean stalled;
    private int lastStackLookedAt = 0;
    private int lastSuceededStack = 0;
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private IRoutedPowerProvider _power;
    private IWorldProvider _world;

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        block29: {
            ItemStack tstack;
            IInventoryUtil invUtil;
            block28: {
                if (--this.currentTick > 0) {
                    return;
                }
                this.currentTick = this.stalled ? 24 : 6;
                invUtil = this._invProvider.getPointedInventory(true);
                if (invUtil == null) {
                    return;
                }
                if (!this._power.canUseEnergy(500)) {
                    this.stalled = true;
                    return;
                }
                if (!(invUtil instanceof SpecialInventoryHandler)) break block28;
                Map items = invUtil.getItemsAndCount();
                if (this.lastSuceededStack >= items.size()) {
                    this.lastSuceededStack = 0;
                }
                if (this.lastStackLookedAt >= items.size()) {
                    this.lastStackLookedAt = 0;
                }
                int lookedAt = 0;
                for (Map.Entry item : items.entrySet()) {
                    if (++lookedAt <= this.lastStackLookedAt) continue;
                    LinkedList<Object> jamList = new LinkedList<Object>();
                    Pair3 reply = this._itemSender.hasDestination((ItemIdentifier)item.getKey(), false, jamList);
                    if (reply == null) {
                        if (this.lastStackLookedAt == this.lastSuceededStack) {
                            this.stalled = true;
                        }
                        ++this.lastStackLookedAt;
                        return;
                    }
                    if (!this._power.useEnergy(500)) {
                        this.stalled = true;
                        ++this.lastStackLookedAt;
                        return;
                    }
                    this.stalled = false;
                    int maxItemsToSend = ((ItemIdentifier)item.getKey()).getMaxStackSize();
                    int availableItems = Math.min(maxItemsToSend, (Integer)item.getValue());
                    while (reply != null) {
                        int count = availableItems;
                        if (((SinkReply)reply.getValue2()).maxNumberOfItems != 0) {
                            count = Math.min(count, ((SinkReply)reply.getValue2()).maxNumberOfItems);
                        }
                        ItemStack stackToSend = invUtil.getMultipleItems((ItemIdentifier)item.getKey(), count);
                        this._itemSender.sendStack(stackToSend, reply, CoreRoutedPipe.ItemSendMode.Fast);
                        MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 8);
                        if ((availableItems -= stackToSend.field_77994_a) <= 0 || !SimpleServiceLocator.buildCraftProxy.checkMaxItems()) break;
                        jamList.add(reply.getValue1());
                        reply = this._itemSender.hasDestination((ItemIdentifier)item.getKey(), false, jamList);
                    }
                    if (availableItems > 0) {
                        this.lastSuceededStack = this.lastStackLookedAt++;
                    } else {
                        this.lastSuceededStack = this.lastStackLookedAt - 1;
                        if (this.lastSuceededStack < 0) {
                            this.lastSuceededStack = items.size() - 1;
                        }
                    }
                    return;
                }
                break block29;
            }
            if (!(invUtil instanceof SpecialInventoryHandler) && invUtil.getSizeInventory() == 0 || !this._power.canUseEnergy(500)) {
                this.stalled = true;
                return;
            }
            if (this.lastSuceededStack >= invUtil.getSizeInventory()) {
                this.lastSuceededStack = 0;
            }
            if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
                this.lastStackLookedAt = 0;
            }
            ItemStack slot = invUtil.getStackInSlot(this.lastStackLookedAt);
            while (slot == null) {
                ++this.lastStackLookedAt;
                if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
                    this.lastStackLookedAt = 0;
                }
                slot = invUtil.getStackInSlot(this.lastStackLookedAt);
                if (this.lastStackLookedAt != this.lastSuceededStack) continue;
                this.stalled = true;
                return;
            }
            LinkedList<Object> jamList = new LinkedList<Object>();
            Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), false, jamList);
            if (reply == null) {
                if (this.lastStackLookedAt == this.lastSuceededStack) {
                    this.stalled = true;
                }
                ++this.lastStackLookedAt;
                return;
            }
            if (!this._power.useEnergy(500)) {
                this.stalled = true;
                ++this.lastStackLookedAt;
                return;
            }
            this.stalled = false;
            slot = slot.func_77946_l();
            int sizePrev = slot.field_77994_a;
            boolean partialSend = false;
            while (reply != null) {
                int count = slot.field_77994_a;
                if (((SinkReply)reply.getValue2()).maxNumberOfItems > 0) {
                    count = Math.min(count, ((SinkReply)reply.getValue2()).maxNumberOfItems);
                }
                ItemStack stackToSend = slot.func_77979_a(count);
                this._itemSender.sendStack(stackToSend, reply, CoreRoutedPipe.ItemSendMode.Fast);
                MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 8);
                if (slot.field_77994_a == 0 || !SimpleServiceLocator.buildCraftProxy.checkMaxItems()) break;
                jamList.add(reply.getValue1());
                reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), false, jamList);
            }
            ItemStack returned = null;
            int amountToExtract = sizePrev - slot.field_77994_a;
            if (slot.field_77994_a > 0) {
                partialSend = true;
            }
            returned = invUtil.decrStackSize(this.lastStackLookedAt, amountToExtract);
            if (returned.field_77994_a != amountToExtract) {
                throw new UnsupportedOperationException("Couldn't extract the already sended items from the inventory.");
            }
            this.lastSuceededStack = this.lastStackLookedAt++;
            if (!partialSend) break block29;
            if (this.lastStackLookedAt >= invUtil.getSizeInventory()) {
                this.lastStackLookedAt = 0;
            }
            while (this.lastStackLookedAt != this.lastSuceededStack && ((tstack = invUtil.getStackInSlot(this.lastStackLookedAt)) == null || slot.func_77969_a(tstack))) {
                ++this.lastStackLookedAt;
                if (this.lastStackLookedAt < invUtil.getSizeInventory()) continue;
                this.lastStackLookedAt = 0;
            }
        }
    }

    @Override
    public void registerSlot(int slot) {
    }

    @Override
    public final int getX() {
        return this._power.getX();
    }

    @Override
    public final int getY() {
        return this._power.getY();
    }

    @Override
    public final int getZ() {
        return this._power.getZ();
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleQuickSort");
    }
}

