/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModulePolymorphicItemSink
extends LogisticsModule {
    private IInventoryProvider _invProvider;
    private IRoutedPowerProvider _power;
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 3, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._power = powerprovider;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > ModulePolymorphicItemSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModulePolymorphicItemSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModulePolymorphicItemSink._sinkReply.customPriority) {
            return null;
        }
        IInventoryUtil targetInventory = this._invProvider.getSneakyInventory(false);
        if (targetInventory == null) {
            return null;
        }
        if (!targetInventory.containsUndamagedItem(item.getUndamaged())) {
            return null;
        }
        if (this._power.canUseEnergy(3)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
    }

    @Override
    public void registerSlot(int slot) {
    }

    @Override
    public final int getX() {
        return this._power.getX();
    }

    @Override
    public final int getY() {
        return this._power.getY();
    }

    @Override
    public final int getZ() {
        return this._power.getZ();
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return true;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModulePolymorphicItemSink");
    }
}

