/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDOreDictItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsGuiModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.module.OreDictItemSinkList;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleOreDictItemSink
extends LogisticsGuiModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    public final List oreList = new LinkedList();
    private Map oreItemIdMap;
    private int slot = 0;
    private IHUDModuleRenderer HUD = new HUDOreDictItemSink(this);
    private List oreHudList;
    private IRoutedPowerProvider _power;
    private IWorldProvider _world;
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.OreDictItemSink, 0, true, false, 5, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._power.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._power.getY();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._power.getZ();
        }
        return -1 - this.slot;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        Set damageSet;
        if (bestPriority > ModuleOreDictItemSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleOreDictItemSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleOreDictItemSink._sinkReply.customPriority) {
            return null;
        }
        if (this.oreItemIdMap == null) {
            this.buildOreItemIdMap();
        }
        if ((damageSet = (Set)this.oreItemIdMap.get(item.itemID)) == null) {
            return null;
        }
        if (damageSet.isEmpty() || damageSet.contains(item.itemDamage)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 43;
    }

    public List getHudItemList() {
        if (this.oreItemIdMap == null) {
            this.buildOreItemIdMap();
        }
        return this.oreHudList;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    private void buildOreItemIdMap() {
        this.oreItemIdMap = new TreeMap();
        this.oreHudList = new ArrayList(this.oreList.size());
        for (String orename : this.oreList) {
            if (orename == null || orename.equals("")) continue;
            ArrayList items = OreDictionary.getOres((String)orename);
            ItemStack stackForHud = null;
            for (ItemStack stack : items) {
                if (stack == null) continue;
                if (stackForHud == null) {
                    stackForHud = stack;
                }
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    this.oreItemIdMap.put(stack.field_77993_c, new TreeSet());
                    continue;
                }
                TreeSet<Integer> damageSet = (TreeSet<Integer>)this.oreItemIdMap.get(stack.field_77993_c);
                if (damageSet == null) {
                    damageSet = new TreeSet<Integer>();
                    damageSet.add(stack.func_77960_j());
                    this.oreItemIdMap.put(stack.field_77993_c, damageSet);
                    continue;
                }
                if (damageSet.isEmpty()) continue;
                damageSet.add(stack.func_77960_j());
            }
            if (stackForHud != null) {
                ItemStack t = stackForHud.func_77946_l();
                if (t.func_77960_j() == Short.MAX_VALUE) {
                    t.func_77964_b(0);
                }
                this.oreHudList.add(new ItemIdentifierStack(ItemIdentifier.get(t), 1));
                continue;
            }
            this.oreHudList.add(new ItemIdentifierStack(ItemIdentifier.get(Block.field_72067_ar.field_71990_ca, 0, null), 1));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.oreList.clear();
        int limit = nbttagcompound.func_74762_e("listSize");
        for (int i = 0; i < limit; ++i) {
            this.oreList.add(nbttagcompound.func_74779_i("Ore" + i));
        }
        this.oreItemIdMap = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("listSize", this.oreList.size());
        for (int i = 0; i < this.oreList.size(); ++i) {
            nbttagcompound.func_74778_a("Ore" + i, (String)this.oreList.get(i));
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Ores: ");
        list.addAll(this.oreList);
        return list;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(((HUDStartModuleWatchingPacket)PacketHandler.getPacket(HUDStartModuleWatchingPacket.class)).setInteger(this.slot).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(((HUDStartModuleWatchingPacket)PacketHandler.getPacket(HUDStartModuleWatchingPacket.class)).setInteger(this.slot).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(((OreDictItemSinkList)PacketHandler.getPacket(OreDictItemSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), (Player)player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    public void OreListChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList(((OreDictItemSinkList)PacketHandler.getPacket(OreDictItemSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(((OreDictItemSinkList)PacketHandler.getPacket(OreDictItemSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
        }
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleOreDictItemSink");
    }
}

