/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDModBasedItemSink;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsGuiModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleBasedItemSinkList;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleModBasedItemSink
extends LogisticsGuiModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver {
    public final List modList = new LinkedList();
    private BitSet modIdSet;
    private int slot = 0;
    private IHUDModuleRenderer HUD = new HUDModBasedItemSink(this);
    private IRoutedPowerProvider _power;
    private IWorldProvider _world;
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ModBasedItemSink, 0, true, false, 5, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._power.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._power.getY();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._power.getZ();
        }
        return -1 - this.slot;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > ModuleModBasedItemSink._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleModBasedItemSink._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleModBasedItemSink._sinkReply.customPriority) {
            return null;
        }
        if (this.modIdSet == null) {
            this.buildModIdSet();
        }
        if (this.modIdSet.get(item.getModId()) && this._power.canUseEnergy(5)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 29;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    private void buildModIdSet() {
        this.modIdSet = new BitSet();
        for (String modname : this.modList) {
            int modid = ItemIdentifier.getModIdForName(modname);
            this.modIdSet.set(modid);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.modList.clear();
        int limit = nbttagcompound.func_74762_e("listSize");
        for (int i = 0; i < limit; ++i) {
            this.modList.add(nbttagcompound.func_74779_i("Mod" + i));
        }
        this.modIdSet = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("listSize", this.modList.size());
        for (int i = 0; i < this.modList.size(); ++i) {
            nbttagcompound.func_74778_a("Mod" + i, (String)this.modList.get(i));
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mods: ");
        list.addAll(this.modList);
        return list;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(((HUDStartModuleWatchingPacket)PacketHandler.getPacket(HUDStartModuleWatchingPacket.class)).setInteger(this.slot).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(((HUDStartModuleWatchingPacket)PacketHandler.getPacket(HUDStartModuleWatchingPacket.class)).setInteger(this.slot).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(((ModuleBasedItemSinkList)PacketHandler.getPacket(ModuleBasedItemSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), (Player)player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    public void ModListChanged() {
        if (MainProxy.isServer(this._world.getWorld())) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendToPlayerList(((ModuleBasedItemSinkList)PacketHandler.getPacket(ModuleBasedItemSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            MainProxy.sendPacketToServer(((ModuleBasedItemSinkList)PacketHandler.getPacket(ModuleBasedItemSinkList.class)).setSlot(this.slot).setTag(nbt).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
        }
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleModBasedItemSink");
    }
}

