/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDElectricManager;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsGuiModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.module.ElectricManagetMode;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ModuleElectricManager
extends LogisticsGuiModule
implements IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive {
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Electric Items", 1);
    private boolean _dischargeMode;
    protected IInventoryProvider _invProvider;
    protected ISendRoutedItem _itemSender;
    protected IRoutedPowerProvider _power;
    private int ticksToAction = 100;
    private int currentTick = 0;
    private int slot = 0;
    private IWorldProvider _world;
    private IHUDModuleRenderer HUD = new HUDElectricManager(this);
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ElectricNetwork, 0, true, false, 1, 1);

    public ModuleElectricManager() {
        this._filterInventory.addListener(this);
    }

    public IInventory getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isDischargeMode() {
        return this._dischargeMode;
    }

    public void setDischargeMode(boolean isDischargeMode) {
        this._dischargeMode = isDischargeMode;
        MainProxy.sendToPlayerList(((ElectricManagetMode)PacketHandler.getPacket(ElectricManagetMode.class)).setInteger(this.slot).setInteger(this.isDischargeMode() ? 1 : 0).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier stackID, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority >= SinkReply.FixedPriority.ElectricNetwork.ordinal()) {
            return null;
        }
        if (!this._power.canUseEnergy(1)) {
            return null;
        }
        ItemStack stack = stackID.makeNormalStack(1);
        if (this.isOfInterest(stack)) {
            if (this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyCharged(stack)) {
                return this._sinkReply;
            }
            if (!this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyDischarged(stack)) {
                return this._sinkReply;
            }
            if (SimpleServiceLocator.IC2Proxy.isPartiallyCharged(stack)) {
                return this._sinkReply;
            }
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 40;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.setDischargeMode(nbttagcompound.func_74767_n("discharge"));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("discharge", this.isDischargeMode());
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction) {
            return;
        }
        this.currentTick = 0;
        IInventoryUtil inv = this._invProvider.getSneakyInventory(true);
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            Pair3 reply;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) {
                return;
            }
            if (!this.isOfInterest(stack)) continue;
            if (this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyDischarged(stack)) {
                reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._itemSender.getSourceID(), true, SinkReply.FixedPriority.ElectricNetwork);
                if (reply == null) continue;
                if (this._power.useEnergy(10)) {
                    MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 2);
                    this._itemSender.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
                    return;
                }
            }
            if (this._dischargeMode || !SimpleServiceLocator.IC2Proxy.isFullyCharged(stack) || (reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._itemSender.getSourceID(), true, SinkReply.FixedPriority.ElectricNetwork)) == null || !this._power.useEnergy(10)) continue;
            MainProxy.sendSpawnParticlePacket(7, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 2);
            this._itemSender.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            return;
        }
    }

    private boolean isOfInterest(ItemStack stack) {
        if (!SimpleServiceLocator.IC2Proxy.isElectricItem(stack)) {
            return false;
        }
        for (int i = 0; i < this._filterInventory.func_70302_i_(); ++i) {
            ItemStack fStack = this._filterInventory.func_70301_a(i);
            if (fStack == null || !SimpleServiceLocator.IC2Proxy.isSimilarElectricItem(stack, fStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mode: " + (this.isDischargeMode() ? "Discharge Items" : "Charge Items"));
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void registerSlot(int slot) {
        this.slot = slot;
    }

    @Override
    public final int getX() {
        if (this.slot >= 0) {
            return this._invProvider.getX();
        }
        return 0;
    }

    @Override
    public final int getY() {
        if (this.slot >= 0) {
            return this._invProvider.getY();
        }
        return -1;
    }

    @Override
    public final int getZ() {
        if (this.slot >= 0) {
            return this._invProvider.getZ();
        }
        return -1 - this.slot;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(((HUDStartModuleWatchingPacket)PacketHandler.getPacket(HUDStartModuleWatchingPacket.class)).setInteger(this.slot).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(((HUDStartModuleWatchingPacket)PacketHandler.getPacket(HUDStartModuleWatchingPacket.class)).setInteger(this.slot).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(((ModuleInventory)PacketHandler.getPacket(ModuleInventory.class)).setSlot(this.slot).setIdentList(ItemIdentifierStack.getListFromInventory(this._filterInventory)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), (Player)player);
        MainProxy.sendPacketToPlayer(((ElectricManagetMode)PacketHandler.getPacket(ElectricManagetMode.class)).setInteger2(this.slot).setInteger(this.isDischargeMode() ? 1 : 0).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), (Player)player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(((ModuleInventory)PacketHandler.getPacket(ModuleInventory.class)).setSlot(this.slot).setIdentList(ItemIdentifierStack.getListFromInventory(inventory)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
    }

    @Override
    public void handleInvContent(Collection list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleElectricManager");
    }
}

