/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SidedInventoryForgeAdapter;
import logisticspipes.utils.SidedInventoryMinecraftAdapter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ISidedInventory;

public class ModuleCrafter
extends LogisticsModule {
    private final PipeItemsCraftingLogistics pipe;
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0);

    public ModuleCrafter(PipeItemsCraftingLogistics parent) {
        this.pipe = parent;
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
    }

    @Override
    public void registerSlot(int slot) {
    }

    @Override
    public final int getX() {
        return this.pipe.getX();
    }

    @Override
    public final int getY() {
        return this.pipe.getY();
    }

    @Override
    public final int getZ() {
        return this.pipe.getZ();
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority > ModuleCrafter._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleCrafter._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleCrafter._sinkReply.customPriority) {
            return null;
        }
        return new SinkReply(_sinkReply, this.spaceFor(item));
    }

    private int spaceFor(ItemIdentifier item) {
        int count = 0;
        WorldUtil wUtil = new WorldUtil(this.pipe.worldObj, this.pipe.getX(), this.pipe.getY(), this.pipe.getZ());
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof IInventory) || tile.tile instanceof TileGenericPipe) continue;
            IInventory base = (IInventory)tile.tile;
            if (base instanceof net.minecraft.inventory.ISidedInventory) {
                base = new SidedInventoryMinecraftAdapter((net.minecraft.inventory.ISidedInventory)base, tile.orientation.getOpposite(), false);
            }
            if (base instanceof ISidedInventory) {
                base = new SidedInventoryForgeAdapter((ISidedInventory)base, tile.orientation.getOpposite());
            }
            IInventoryUtil inv = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(base);
            count += inv.roomForItem(item, 9999);
        }
        return count;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public Collection getSpecificInterests() {
        return this.pipe.getSpecificInterests();
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return null;
    }
}

