/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import buildcraft.api.inventory.ISpecialInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class ModuleApiaristRefiller
extends LogisticsModule {
    private IInventoryProvider _invProvider;
    private IRoutedPowerProvider _power;
    private ISendRoutedItem _itemSender;
    private IWorldProvider _world;
    private int currentTickCount = 0;
    private int ticksToOperation = 200;

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerProvider) {
        this._invProvider = invProvider;
        this._power = powerProvider;
        this._world = world;
        this._itemSender = itemSender;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void registerSlot(int slot) {
    }

    @Override
    public final int getX() {
        return this._invProvider.getX();
    }

    @Override
    public final int getY() {
        return this._invProvider.getY();
    }

    @Override
    public final int getZ() {
        return this._invProvider.getZ();
    }

    @Override
    public void tick() {
        if (++this.currentTickCount < this.ticksToOperation) {
            return;
        }
        this.currentTickCount = 0;
        IInventory inv = this._invProvider.getRealInventory();
        if (!(inv instanceof ISpecialInventory)) {
            return;
        }
        ISpecialInventory sinv = (ISpecialInventory)inv;
        ForgeDirection direction = this._invProvider.inventoryOrientation().getOpposite();
        ItemStack[] stack = sinv.extractItem(false, direction, 1);
        if (stack == null || stack.length < 1 || stack[0] == null) {
            return;
        }
        if (!this._power.canUseEnergy(100)) {
            return;
        }
        this.currentTickCount = this.ticksToOperation;
        if (this.reinsertBee(stack[0], sinv, direction)) {
            return;
        }
        Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(stack[0]), true, new ArrayList());
        if (reply == null) {
            return;
        }
        this._power.useEnergy(20);
        sinv.extractItem(true, direction, 1);
        this._itemSender.sendStack(stack[0], reply, CoreRoutedPipe.ItemSendMode.Normal);
    }

    private boolean reinsertBee(ItemStack stack, ISpecialInventory inv, ForgeDirection direction) {
        if (inv.func_70301_a(0) == null && SimpleServiceLocator.forestryProxy.isPrincess(stack) && SimpleServiceLocator.forestryProxy.isPurebred(stack)) {
            int inserted = inv.addItem(stack, true, direction);
            if (inserted == 0) {
                return false;
            }
            this._power.useEnergy(100);
            inv.extractItem(true, direction, 1);
            MainProxy.sendSpawnParticlePacket(6, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 5);
            MainProxy.sendSpawnParticlePacket(3, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 5);
            return true;
        }
        if (inv.func_70301_a(1) == null && !SimpleServiceLocator.forestryProxy.isQueen(inv.func_70301_a(0)) && SimpleServiceLocator.forestryProxy.isDrone(stack) && SimpleServiceLocator.forestryProxy.isPurebred(stack)) {
            int inserted = inv.addItem(stack, true, direction);
            if (inserted == 0) {
                return false;
            }
            this._power.useEnergy(100);
            inv.extractItem(true, direction, 1);
            MainProxy.sendSpawnParticlePacket(6, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 5);
            MainProxy.sendSpawnParticlePacket(3, this.getX(), this.getY(), this.getZ(), this._world.getWorld(), 5);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIconTexture(IconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleApiaristRefiller");
    }
}

