/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.main;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.utils.PlayerCollectionList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class LogisticsEventListener
implements IPlayerTracker {
    public static HashMap WorldLoadTime = new HashMap();
    public static Map watcherList = new ConcurrentHashMap();
    int taskCount = 0;

    @ForgeSubscribe
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        ItemStack stack;
        if (event != null && event.entity instanceof EntityItem && event.entity.field_70170_p != null && !event.entity.field_70170_p.field_72995_K && (stack = ((EntityItem)event.entity).func_92059_d()) != null && stack.func_77973_b() instanceof IItemAdvancedExistance && !((IItemAdvancedExistance)stack.func_77973_b()).canExistInWorld(stack)) {
            event.setCanceled(true);
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) throws IOException {
        if (event.map == Minecraft.func_71410_x().field_71446_o.field_94155_m) {
            LogisticsPipes.textures.registerItemIcons((IconRegister)event.map);
        }
        if (event.map == Minecraft.func_71410_x().field_71446_o.field_94154_l) {
            LogisticsPipes.textures.registerBlockIcons();
        }
    }

    @ForgeSubscribe
    public void onPlayerInteract(PlayerInteractEvent event) {
        TileEntity tile;
        if (MainProxy.isServer(event.entityPlayer.field_70170_p) && event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (tile = event.entityPlayer.field_70170_p.func_72796_p(event.x, event.y, event.z)) instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe instanceof CoreRoutedPipe) {
            if (!((CoreRoutedPipe)((TileGenericPipe)tile).pipe).canBeDestroyedByPlayer(event.entityPlayer)) {
                event.setCanceled(true);
                event.entityPlayer.func_70006_a("Permission Denied");
                ((TileGenericPipe)tile).scheduleNeighborChange();
                event.entityPlayer.field_70170_p.func_72845_h(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
                ((CoreRoutedPipe)((TileGenericPipe)tile).pipe).delayTo = System.currentTimeMillis() + 200L;
                ((CoreRoutedPipe)((TileGenericPipe)tile).pipe).repeatFor = 10;
            } else {
                ((CoreRoutedPipe)((TileGenericPipe)tile).pipe).setDestroyByPlayer();
            }
        }
    }

    @ForgeSubscribe
    public void WorldLoad(WorldEvent.Load event) {
        int dim;
        if (MainProxy.isServer(event.world) && !WorldLoadTime.containsKey(dim = MainProxy.getDimensionForWorld(event.world))) {
            WorldLoadTime.put(dim, System.currentTimeMillis());
        }
        if (MainProxy.isClient(event.world)) {
            SimpleServiceLocator.routerManager.clearClientRouters();
            LogisticsHUDRenderer.instance().clear();
        }
    }

    @ForgeSubscribe
    public void WorldUnload(WorldEvent.Unload event) {
        if (MainProxy.isServer(event.world)) {
            int dim = MainProxy.getDimensionForWorld(event.world);
            SimpleServiceLocator.routerManager.dimensionUnloaded(dim);
        }
    }

    @ForgeSubscribe
    public void watchChunk(ChunkWatchEvent.Watch event) {
        if (!watcherList.containsKey(event.chunk)) {
            watcherList.put(event.chunk, new PlayerCollectionList());
        }
        ((PlayerCollectionList)watcherList.get(event.chunk)).add((EntityPlayer)event.player);
    }

    @ForgeSubscribe
    public void unWatchChunk(ChunkWatchEvent.UnWatch event) {
        if (watcherList.containsKey(event.chunk)) {
            ((PlayerCollectionList)watcherList.get(event.chunk)).remove((EntityPlayer)event.player);
        }
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (MainProxy.isServer(player.field_70170_p)) {
            SimpleServiceLocator.securityStationManager.sendClientAuthorizationList(player);
        }
    }

    public void onPlayerLogout(EntityPlayer player) {
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }
}

