/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import logisticspipes.interfaces.routing.IFilteringRouter;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import net.minecraftforge.common.ForgeDirection;

public class RouteLayer {
    protected final IRouter _router;
    private final TransportLayer _transport;

    public RouteLayer(IRouter router, TransportLayer transport) {
        this._router = router;
        this._transport = transport;
    }

    public ForgeDirection getOrientationForItem(IRoutedItem item, ForgeDirection blocked) {
        item.checkIDFromUUID();
        if (item.getDestination() < 0) {
            item = SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getSimpleID(), false);
        }
        if (item.getDestination() >= 0 && (!this._router.hasRoute(item.getDestination()) || item.getArrived())) {
            if (!item.isItemRelayed()) {
                item = SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getSimpleID(), false);
            } else {
                int destination = item.getDestination();
                for (ExitRoute node : this._router.getIRoutersByCost()) {
                    if (!(node.destination instanceof IFilteringRouter) || !((IFilteringRouter)((Object)node.destination)).isIdforOtherSide(destination)) continue;
                    item.replaceRelayID(node.destination.getSimpleID());
                    break;
                }
            }
        }
        item.checkIDFromUUID();
        if (item.getDestination() < 0) {
            return ForgeDirection.UNKNOWN;
        }
        if (item.getDestinationUUID().equals(this._router.getId())) {
            if (!this._transport.stillWantItem(item)) {
                return this.getOrientationForItem(SimpleServiceLocator.logisticsManager.assignDestinationFor(item, this._router.getSimpleID(), true), null);
            }
            item.setDoNotBuffer(true);
            ForgeDirection o = this._transport.itemArrived(item, blocked);
            return o != null ? o : ForgeDirection.UNKNOWN;
        }
        if (!this._router.hasRoute(item.getDestination())) {
            return ForgeDirection.UNKNOWN;
        }
        return this._router.getExitFor(item.getDestination());
    }
}

