/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsGuiModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SinkReply;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ChassiModule
extends LogisticsGuiModule {
    private final LogisticsModule[] _modules;
    private final PipeLogisticsChassi _parentPipe;

    public ChassiModule(int moduleCount, PipeLogisticsChassi parentPipe) {
        this._modules = new LogisticsModule[moduleCount];
        this._parentPipe = parentPipe;
    }

    public void installModule(int slot, LogisticsModule module) {
        this._modules[slot] = module;
    }

    public void removeModule(int slot) {
        this._modules[slot] = null;
    }

    public LogisticsModule getModule(int slot) {
        return this._modules[slot];
    }

    public boolean hasModule(int slot) {
        return this._modules[slot] != null;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        SinkReply bestresult = null;
        for (LogisticsModule module : this._modules) {
            SinkReply result;
            if (module == null || (result = module.sinksItem(item, bestPriority, bestCustomPriority, allowDefault, includeInTransit)) == null) continue;
            bestresult = result;
            bestPriority = result.fixedPriority.ordinal();
            bestCustomPriority = result.customPriority;
        }
        if (bestresult == null) {
            return null;
        }
        IInventoryUtil invUtil = this._parentPipe.getSneakyInventory(false);
        if (invUtil == null) {
            return null;
        }
        int roomForItem = invUtil.roomForItem(item);
        if (roomForItem < 1) {
            return null;
        }
        if (includeInTransit && (roomForItem -= this._parentPipe.countOnRoute(item)) < 1) {
            return null;
        }
        if (bestresult.maxNumberOfItems == 0) {
            return new SinkReply(bestresult, roomForItem);
        }
        return new SinkReply(bestresult, Math.min(bestresult.maxNumberOfItems, roomForItem));
    }

    @Override
    public int getGuiHandlerID() {
        return 26;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        if (slot < 0 || slot >= this._modules.length) {
            return null;
        }
        return this._modules[slot];
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this._modules.length; ++i) {
            NBTTagCompound slot;
            if (this._modules[i] == null || (slot = nbttagcompound.func_74775_l("slot" + i)) == null) continue;
            this._modules[i].readFromNBT(slot);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this._modules.length; ++i) {
            if (this._modules[i] == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            this._modules[i].writeToNBT(slot);
            nbttagcompound.func_74782_a("slot" + i, (NBTBase)slot);
        }
    }

    @Override
    public void tick() {
        for (LogisticsModule module : this._modules) {
            if (module == null) continue;
            module.tick();
        }
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
    }

    @Override
    public void registerSlot(int slot) {
    }

    @Override
    public final int getX() {
        return this._parentPipe.getX();
    }

    @Override
    public final int getY() {
        return this._parentPipe.getX();
    }

    @Override
    public final int getZ() {
        return this._parentPipe.getX();
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        for (LogisticsModule module : this._modules) {
            if (module == null || !module.recievePassive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Icon getIconTexture(IconRegister register) {
        return null;
    }
}

