/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.energy.EngineWood;
import buildcraft.energy.TileEngine;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.modules.SupplierPipeMode;
import logisticspipes.pipes.PipeItemsSupplierLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public class LogicSupplier
extends BaseRoutingLogic
implements IRequireReliableTransport {
    private SimpleInventory dummyInventory = new SimpleInventory(9, "Items to keep stocked", 127);
    private final HashMap _requestedItems = new HashMap();
    private boolean _requestPartials = false;
    public boolean pause = false;
    public IRoutedPowerProvider _power;

    public LogicSupplier() {
        this.throttleTime = 100;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        if (MainProxy.isServer(entityplayer.field_70170_p)) {
            entityplayer.openGui((Object)LogisticsPipes.instance, 14, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            MainProxy.sendPacketToPlayer(((SupplierPipeMode)PacketHandler.getPacket(SupplierPipeMode.class)).setInteger(this.isRequestingPartials() ? 1 : 0).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)entityplayer);
        }
    }

    public SimpleInventory getDummyInventory() {
        return this.dummyInventory;
    }

    @Override
    public void throttledUpdateEntity() {
        if (!((CoreRoutedPipe)this.container.pipe).isEnabled()) {
            return;
        }
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        if (this.pause) {
            return;
        }
        super.throttledUpdateEntity();
        Iterator i$ = this._requestedItems.values().iterator();
        while (i$.hasNext()) {
            int amount = (Integer)i$.next();
            if (amount <= 0) continue;
            MainProxy.sendSpawnParticlePacket(6, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 2);
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        block1: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            IInventory inv;
            if (tile.tile instanceof TileGenericPipe || !(tile.tile instanceof IInventory) || tile.tile instanceof TileEngine && ((TileEngine)tile.tile).engine instanceof EngineWood || (inv = (IInventory)tile.tile).func_70302_i_() < 1) continue;
            IInventoryUtil invUtil = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv);
            HashMap needed = new HashMap(this.dummyInventory.getItemsAndCount());
            Map have = invUtil.getItemsAndCount();
            HashMap haveUndamaged = new HashMap();
            for (Map.Entry entry : have.entrySet()) {
                Integer n = (Integer)haveUndamaged.get(((ItemIdentifier)entry.getKey()).getUndamaged());
                if (n == null) {
                    haveUndamaged.put(((ItemIdentifier)entry.getKey()).getUndamaged(), entry.getValue());
                    continue;
                }
                haveUndamaged.put(((ItemIdentifier)entry.getKey()).getUndamaged(), (Integer)entry.getValue() + n);
            }
            for (Map.Entry entry : needed.entrySet()) {
                Integer requestedCount;
                Integer haveCount = (Integer)haveUndamaged.get(((ItemIdentifier)entry.getKey()).getUndamaged());
                if (haveCount != null) {
                    entry.setValue((Integer)entry.getValue() - haveCount);
                    haveUndamaged.put(((ItemIdentifier)entry.getKey()).getUndamaged(), haveCount - (Integer)entry.getValue());
                }
                if ((requestedCount = (Integer)this._requestedItems.get(entry.getKey())) == null) continue;
                entry.setValue((Integer)entry.getValue() - requestedCount);
            }
            ((PipeItemsSupplierLogistics)this.container.pipe).setRequestFailed(false);
            for (Map.Entry entry : needed.entrySet()) {
                Integer amountRequested = (Integer)entry.getValue();
                if (amountRequested == null || amountRequested < 1) continue;
                int neededCount = amountRequested;
                if (!this._power.useEnergy(10)) continue block1;
                boolean success = false;
                if (this._requestPartials) {
                    neededCount = RequestTree.requestPartial(((ItemIdentifier)entry.getKey()).makeStack(neededCount), (IRequestItems)this.container.pipe);
                    if (neededCount > 0) {
                        success = true;
                    }
                } else {
                    boolean bl = success = RequestTree.request(((ItemIdentifier)entry.getKey()).makeStack(neededCount), (IRequestItems)this.container.pipe, null) > 0;
                }
                if (success) {
                    Integer currentRequest = (Integer)this._requestedItems.get(entry.getKey());
                    if (currentRequest == null) {
                        this._requestedItems.put(entry.getKey(), neededCount);
                        continue;
                    }
                    this._requestedItems.put(entry.getKey(), currentRequest + neededCount);
                    continue;
                }
                ((PipeItemsSupplierLogistics)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.func_74767_n("requestpartials");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("requestpartials", this._requestPartials);
    }

    private void decreaseRequested(ItemIdentifierStack item) {
        int remaining = item.stackSize;
        Integer count = (Integer)this._requestedItems.get(item.getItem());
        if (count != null) {
            this._requestedItems.put(item.getItem(), Math.max(0, count - remaining));
            remaining -= count.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        for (Map.Entry entry : this._requestedItems.entrySet()) {
            if (((ItemIdentifier)entry.getKey()).itemID == item.getItem().itemID && ((ItemIdentifier)entry.getKey()).itemDamage == item.getItem().itemDamage) {
                int expected = (Integer)entry.getValue();
                entry.setValue(Math.max(0, expected - remaining));
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        LogisticsPipes.requestLog.info("supplier got unexpected item " + item.toString());
    }

    @Override
    public void itemLost(ItemIdentifierStack item) {
        this.decreaseRequested(item);
    }

    @Override
    public void itemArrived(ItemIdentifierStack item) {
        this.decreaseRequested(item);
        this.delayThrottle();
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }
}

