/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.interfaces.routing.IRequireReliableLiquidTransport;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.LiquidSupplierAmount;
import logisticspipes.pipes.PipeLiquidSupplierMk2;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;

public class LogicLiquidSupplierMk2
extends BaseRoutingLogic
implements IRequireReliableLiquidTransport {
    private SimpleInventory dummyInventory = new SimpleInventory(1, "Liquid to keep stocked", 127);
    private int amount = 0;
    private final Map _requestedItems = new HashMap();
    private boolean _requestPartials = false;
    public IRoutedPowerProvider _power;

    public LogicLiquidSupplierMk2() {
        this.throttleTime = 100;
    }

    @Override
    public void throttledUpdateEntity() {
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        super.throttledUpdateEntity();
        if (this.dummyInventory.func_70301_a(0) == null) {
            return;
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            ILiquidTank[] result;
            ITankContainer container;
            if (!(tile.tile instanceof ITankContainer) || tile.tile instanceof TileGenericPipe || (container = (ITankContainer)tile.tile).getTanks(ForgeDirection.UNKNOWN) == null || container.getTanks(ForgeDirection.UNKNOWN).length == 0) continue;
            HashMap<LiquidIdentifier, Integer> wantLiquids = new HashMap<LiquidIdentifier, Integer>();
            wantLiquids.put(ItemIdentifier.get(this.dummyInventory.func_70301_a(0)).getLiquidIdentifier(), this.amount);
            HashMap<LiquidIdentifier, Integer> haveLiquids = new HashMap<LiquidIdentifier, Integer>();
            for (ILiquidTank slot : result = container.getTanks(ForgeDirection.UNKNOWN)) {
                if (slot.getLiquid() == null || !wantLiquids.containsKey(LiquidIdentifier.get(slot.getLiquid()))) continue;
                Integer liquidWant = (Integer)haveLiquids.get(LiquidIdentifier.get(slot.getLiquid()));
                if (liquidWant == null) {
                    haveLiquids.put(LiquidIdentifier.get(slot.getLiquid()), slot.getLiquid().amount);
                    continue;
                }
                haveLiquids.put(LiquidIdentifier.get(slot.getLiquid()), liquidWant + slot.getLiquid().amount);
            }
            for (Map.Entry entry : wantLiquids.entrySet()) {
                Integer haveCount = (Integer)haveLiquids.get(entry.getKey());
                if (haveCount != null) {
                    entry.setValue((Integer)entry.getValue() - haveCount);
                }
                for (Map.Entry requestedItem : this._requestedItems.entrySet()) {
                    if (requestedItem.getKey() != entry.getKey()) continue;
                    entry.setValue((Integer)entry.getValue() - (Integer)requestedItem.getValue());
                }
            }
            ((PipeLiquidSupplierMk2)this.container.pipe).setRequestFailed(false);
            for (LiquidIdentifier liquidIdentifier : wantLiquids.keySet()) {
                int countToRequest = (Integer)wantLiquids.get(liquidIdentifier);
                if (countToRequest < 1) continue;
                if (!this._power.useEnergy(11)) continue block0;
                boolean success = false;
                if (this._requestPartials) {
                    if ((countToRequest = RequestTree.requestLiquidPartial(liquidIdentifier, countToRequest, (IRequestLiquid)this.container.pipe, null)) > 0) {
                        success = true;
                    }
                } else {
                    boolean bl = success = RequestTree.requestLiquid(liquidIdentifier, countToRequest, (IRequestLiquid)this.container.pipe, null) > 0;
                }
                if (success) {
                    Integer currentRequest = (Integer)this._requestedItems.get(liquidIdentifier);
                    if (currentRequest == null) {
                        this._requestedItems.put(liquidIdentifier, countToRequest);
                        continue;
                    }
                    this._requestedItems.put(liquidIdentifier, currentRequest + countToRequest);
                    continue;
                }
                ((PipeLiquidSupplierMk2)this.container.pipe).setRequestFailed(true);
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.func_74767_n("requestpartials");
        this.amount = nbttagcompound.func_74762_e("amount");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("requestpartials", this._requestPartials);
        nbttagcompound.func_74768_a("amount", this.amount);
    }

    private void decreaseRequested(LiquidIdentifier liquid, int remaining) {
        Integer count = (Integer)this._requestedItems.get(liquid);
        if (count != null) {
            this._requestedItems.put(liquid, Math.max(0, count - remaining));
            remaining -= count.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        for (Map.Entry entry : this._requestedItems.entrySet()) {
            if (((LiquidIdentifier)entry.getKey()).itemId == liquid.itemId && ((LiquidIdentifier)entry.getKey()).itemMeta == liquid.itemMeta) {
                int expected = (Integer)entry.getValue();
                entry.setValue(Math.max(0, expected - remaining));
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        LogisticsPipes.requestLog.info("liquid supplier got unexpected item " + liquid.toString());
    }

    @Override
    public void liquidLost(LiquidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
    }

    @Override
    public void liquidArrived(LiquidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
        this.delayThrottle();
    }

    @Override
    public void liquidNotInserted(LiquidIdentifier item, int amount) {
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        if (MainProxy.isServer(entityplayer.field_70170_p)) {
            entityplayer.openGui((Object)LogisticsPipes.instance, 18, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void destroy() {
    }

    public IInventory getDummyInventory() {
        return this.dummyInventory;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        if (MainProxy.isClient(this.worldObj)) {
            this.amount = amount;
        }
    }

    public void changeLiquidAmount(int change, EntityPlayer player) {
        this.amount += change;
        if (this.amount <= 0) {
            this.amount = 0;
        }
        MainProxy.sendPacketToPlayer(((LiquidSupplierAmount)PacketHandler.getPacket(LiquidSupplierAmount.class)).setInteger(this.amount).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
    }
}

