/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.transport.pipes.PipeLogic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.RequestRoutingLasersPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ServerRouter;
import logisticspipes.security.SecuritySettings;
import logisticspipes.utils.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.ForgeDirection;

public abstract class BaseRoutingLogic
extends PipeLogic {
    protected int throttleTime = 20;
    private int throttleTimeLeft = 20 + new Random().nextInt(Configs.LOGISTICS_DETECTION_FREQUENCY);

    public CoreRoutedPipe getRoutedPipe() {
        return (CoreRoutedPipe)this.container.pipe;
    }

    public abstract void onWrenchClicked(EntityPlayer var1);

    public abstract void destroy();

    public void updateEntity() {
        super.updateEntity();
        if (--this.throttleTimeLeft > 0) {
            return;
        }
        this.throttledUpdateEntity();
        this.throttleTimeLeft = this.throttleTime;
    }

    public void throttledUpdateEntity() {
    }

    protected void delayThrottle() {
        if (this.throttleTimeLeft < 7) {
            this.throttleTimeLeft = 7;
        }
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        LogisticsSecurityTileEntity station;
        SecuritySettings settings = null;
        if (MainProxy.isServer(entityplayer.field_70170_p) && (station = SimpleServiceLocator.securityStationManager.getStation(this.getRoutedPipe().getUpgradeManager().getSecurityID())) != null) {
            settings = station.getSecuritySettingsForPlayer(entityplayer, false);
        }
        if (entityplayer.func_71045_bC() == null) {
            if (!entityplayer.func_70093_af()) {
                return false;
            }
            if (MainProxy.isClient(entityplayer.field_70170_p)) {
                if (!LogisticsHUDRenderer.instance().hasLasers()) {
                    MainProxy.sendPacketToServer(((RequestRoutingLasersPacket)PacketHandler.getPacket(RequestRoutingLasersPacket.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
                } else {
                    LogisticsHUDRenderer.instance().resetLasers();
                }
            }
            if (LogisticsPipes.DEBUG) {
                this.doDebugStuff(entityplayer);
            }
            return true;
        }
        if (entityplayer.func_71045_bC().func_77973_b() == LogisticsPipes.LogisticsNetworkMonitior && (settings == null || settings.openNetworkMonitor)) {
            if (MainProxy.isServer(entityplayer.field_70170_p)) {
                entityplayer.openGui((Object)LogisticsPipes.instance, 30, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
            return true;
        }
        if (SimpleServiceLocator.buildCraftProxy.isWrenchEquipped(entityplayer) && (settings == null || settings.openGui)) {
            this.onWrenchClicked(entityplayer);
            return true;
        }
        if (entityplayer.func_71045_bC().func_77973_b() == LogisticsPipes.LogisticsRemoteOrderer && (settings == null || settings.openRequest)) {
            if (MainProxy.isServer(entityplayer.field_70170_p)) {
                entityplayer.openGui((Object)LogisticsPipes.instance, 31, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
            return true;
        }
        if (entityplayer.func_71045_bC().func_77973_b() == LogisticsPipes.LogisticsRemoteOrderer) {
            if (MainProxy.isServer(entityplayer.field_70170_p)) {
                entityplayer.func_70006_a("Permission denied");
            }
            return true;
        }
        if (entityplayer.func_71045_bC().func_77973_b() == LogisticsPipes.LogisticsNetworkMonitior) {
            if (MainProxy.isServer(entityplayer.field_70170_p)) {
                entityplayer.func_70006_a("Permission denied");
            }
            return true;
        }
        return super.blockActivated(entityplayer);
    }

    private void doDebugStuff(EntityPlayer entityplayer) {
        IRouter r = this.getRoutedPipe().getRouter();
        if (!(r instanceof ServerRouter)) {
            return;
        }
        System.out.println("***");
        System.out.println("---------Interests---------------");
        for (Map.Entry i : ServerRouter.getInterestedInSpecifics().entrySet()) {
            System.out.print(((ItemIdentifier)i.getKey()).getFriendlyName() + ":");
            for (IRouter j : (Set)i.getValue()) {
                System.out.print(j.getSimpleID() + ",");
            }
            System.out.println();
        }
        System.out.print("ALL ITEMS:");
        for (IRouter j : ServerRouter.getInterestedInGeneral()) {
            System.out.print(j.getSimpleID() + ",");
        }
        System.out.println();
        ServerRouter sr = (ServerRouter)r;
        System.out.println(r.toString());
        System.out.println("---------CONNECTED TO---------------");
        for (CoreRoutedPipe adj : sr._adjacent.keySet()) {
            System.out.println(adj.getRouter().getSimpleID());
        }
        System.out.println();
        System.out.println("========DISTANCE TABLE==============");
        for (ExitRoute n : r.getIRoutersByCost()) {
            System.out.println(n.destination.getSimpleID() + " @ " + n.distanceToDestination + " -> " + n.connectionDetails + "(" + n.destination.getId() + ")");
        }
        System.out.println();
        System.out.println("*******EXIT ROUTE TABLE*************");
        ArrayList table = r.getRouteTable();
        for (int i = 0; i < table.size(); ++i) {
            if (table.get(i) == null) continue;
            System.out.println(i + " -> " + r.getSimpleID() + " via " + ((ExitRoute)table.get((int)i)).exitOrientation + "(" + table.get(i) + " distance)");
        }
        System.out.println();
        System.out.println("++++++++++CONNECTIONS+++++++++++++++");
        System.out.println(Arrays.toString(ForgeDirection.VALID_DIRECTIONS));
        System.out.println(Arrays.toString(sr.sideDisconnected));
        System.out.println(Arrays.toString(this.getRoutedPipe().container.pipeConnectionsBuffer));
        System.out.println();
        System.out.println("~~~~~~~~~~~~~~~POWER~~~~~~~~~~~~~~~~");
        System.out.println(r.getPipe().getRoutedPowerProviders());
        System.out.println(r.getPowerProvider());
        this.getRoutedPipe().refreshConnectionAndRender(true);
    }
}

