/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.core.network.TileNetworkData;
import cpw.mods.fml.common.network.Player;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.interfaces.routing.IRequireReliableLiquidTransport;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.packets.satpipe.SatPipeNext;
import logisticspipes.network.packets.satpipe.SatPipePrev;
import logisticspipes.network.packets.satpipe.SatPipeSetID;
import logisticspipes.pipes.PipeLiquidSatellite;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestTree;
import logisticspipes.utils.LiquidIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class BaseLogicLiquidSatellite
extends BaseRoutingLogic
implements IRequireReliableLiquidTransport {
    public static HashSet AllSatellites = new HashSet();
    protected final Map _lostItems = new HashMap();
    @TileNetworkData
    public int satelliteId;

    public static void cleanup() {
        AllSatellites.clear();
    }

    public BaseLogicLiquidSatellite() {
        this.throttleTime = 40;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.satelliteId = nbttagcompound.func_74762_e("satelliteid");
        this.ensureAllSatelliteStatus();
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("satelliteid", this.satelliteId);
        super.writeToNBT(nbttagcompound);
    }

    protected int findId(int increment) {
        if (MainProxy.isClient(this.worldObj)) {
            return this.satelliteId;
        }
        int potentialId = this.satelliteId;
        boolean conflict = true;
        block0: while (conflict) {
            if ((potentialId += increment) < 0) {
                return 0;
            }
            conflict = false;
            for (BaseLogicLiquidSatellite sat : AllSatellites) {
                if (sat.satelliteId != potentialId) continue;
                conflict = true;
                continue block0;
            }
        }
        return potentialId;
    }

    protected void ensureAllSatelliteStatus() {
        if (MainProxy.isClient()) {
            return;
        }
        if (this.satelliteId == 0 && AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
        if (this.satelliteId != 0 && !AllSatellites.contains(this)) {
            AllSatellites.add(this);
        }
    }

    public void setNextId(EntityPlayer player) {
        this.satelliteId = this.findId(1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = ((SatPipeNext)PacketHandler.getPacket(SatPipeNext.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToServer(packet);
        } else {
            CoordinatesPacket packet = ((SatPipeSetID)PacketHandler.getPacket(SatPipeSetID.class)).setSatID(this.satelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToPlayer(packet, (Player)player);
        }
        this.updateWatchers();
    }

    public void setPrevId(EntityPlayer player) {
        this.satelliteId = this.findId(-1);
        this.ensureAllSatelliteStatus();
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = ((SatPipePrev)PacketHandler.getPacket(SatPipePrev.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToServer(packet);
        } else {
            CoordinatesPacket packet = ((SatPipeSetID)PacketHandler.getPacket(SatPipeSetID.class)).setSatID(this.satelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToPlayer(packet, (Player)player);
        }
        this.updateWatchers();
    }

    private void updateWatchers() {
        MainProxy.sendToPlayerList(((SatPipeSetID)PacketHandler.getPacket(SatPipeSetID.class)).setSatID(this.satelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), ((PipeLiquidSatellite)this.container.pipe).localModeWatchers);
    }

    @Override
    public void destroy() {
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        if (AllSatellites.contains(this)) {
            AllSatellites.remove(this);
        }
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        if (MainProxy.isServer(entityplayer.field_70170_p)) {
            CoordinatesPacket packet = ((SatPipeSetID)PacketHandler.getPacket(SatPipeSetID.class)).setSatID(this.satelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToPlayer(packet, (Player)entityplayer);
            entityplayer.openGui((Object)LogisticsPipes.instance, 13, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        Iterator iterator = this._lostItems.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry stack = iterator.next();
            int received = RequestTree.requestLiquidPartial((LiquidIdentifier)stack.getKey(), (Integer)stack.getValue(), (IRequestLiquid)((Object)this.getRoutedPipe()), null);
            if (received <= 0) continue;
            if (received == (Integer)stack.getValue()) {
                iterator.remove();
                continue;
            }
            stack.setValue((Integer)stack.getValue() - received);
        }
    }

    public void setSatelliteId(int integer) {
        this.satelliteId = integer;
    }

    @Override
    public void liquidLost(LiquidIdentifier item, int amount) {
        if (this._lostItems.containsKey(item)) {
            this._lostItems.put(item, (Integer)this._lostItems.get(item) + amount);
        } else {
            this._lostItems.put(item, amount);
        }
    }

    @Override
    public void liquidArrived(LiquidIdentifier item, int amount) {
    }

    @Override
    public void liquidNotInserted(LiquidIdentifier item, int amount) {
        this.liquidLost(item, amount);
    }
}

