/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import buildcraft.core.network.TileNetworkData;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.DelayQueue;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseLogicLiquidSatellite;
import logisticspipes.logic.BaseLogicSatellite;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.logistics.LogisticsManagerV2;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.packets.block.CraftingPipeNextAdvancedSatellitePacket;
import logisticspipes.network.packets.block.CraftingPipePrevAdvancedSatellitePacket;
import logisticspipes.network.packets.cpipe.CPipeNextSatellite;
import logisticspipes.network.packets.cpipe.CPipePrevSatellite;
import logisticspipes.network.packets.cpipe.CPipeSatelliteId;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImport;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImportBack;
import logisticspipes.network.packets.cpipe.CraftingAdvancedSatelliteId;
import logisticspipes.network.packets.cpipe.CraftingPipeOpenConnectedGuiPacket;
import logisticspipes.network.packets.gui.GuiArgument;
import logisticspipes.network.packets.pipe.CraftingPipePriorityDownPacket;
import logisticspipes.network.packets.pipe.CraftingPipePriorityUpPacket;
import logisticspipes.network.packets.pipe.CraftingPipeStackMovePacket;
import logisticspipes.network.packets.pipe.CraftingPriority;
import logisticspipes.network.packets.pipe.LiquidCraftingAdvancedSatelliteId;
import logisticspipes.network.packets.pipe.LiquidCraftingAmount;
import logisticspipes.network.packets.pipe.LiquidCraftingPipeAdvancedSatelliteNextPacket;
import logisticspipes.network.packets.pipe.LiquidCraftingPipeAdvancedSatellitePrevPacket;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.request.RequestTree;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.DelayedGeneric;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class BaseLogicCrafting
extends BaseRoutingLogic
implements IRequireReliableTransport {
    protected SimpleInventory _dummyInventory = new SimpleInventory(11, "Requested items", 127);
    protected SimpleInventory _liquidInventory = new SimpleInventory(3, "Liquid items", 1);
    @TileNetworkData(staticSize=3)
    protected int[] amount = new int[3];
    @TileNetworkData(staticSize=3)
    public int[] liquidSatelliteIdArray = new int[3];
    @TileNetworkData
    public int liquidSatelliteId = 0;
    @TileNetworkData(staticSize=6)
    public boolean[] craftingSigns = new boolean[6];
    protected final DelayQueue _lostItems = new DelayQueue();
    @TileNetworkData
    public int satelliteId = 0;
    @TileNetworkData(staticSize=9)
    public int[] advancedSatelliteIdArray = new int[9];
    @TileNetworkData
    public int priority = 0;
    private PipeItemsCraftingLogistics _pipe = null;

    public BaseLogicCrafting() {
        this.throttleTime = 40;
    }

    protected int getNextConnectSatelliteId(boolean prev, int x) {
        int closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
            CoreRoutedPipe satPipe = satellite.getRoutedPipe();
            if (satPipe == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null || satPipe.isLiquidPipe()) continue;
            IRouter satRouter = satPipe.getRouter();
            ExitRoute route = this.getRoutedPipe().getRouter().getDistanceTo(satRouter);
            if (route == null) continue;
            if (x == -1) {
                if (!prev && satellite.satelliteId > this.satelliteId && satellite.satelliteId < closestIdFound) {
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (!prev || satellite.satelliteId >= this.satelliteId || satellite.satelliteId <= closestIdFound) continue;
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev && satellite.satelliteId > this.advancedSatelliteIdArray[x] && satellite.satelliteId < closestIdFound) {
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev || satellite.satelliteId >= this.advancedSatelliteIdArray[x] || satellite.satelliteId <= closestIdFound) continue;
            closestIdFound = satellite.satelliteId;
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            if (x == -1) {
                return this.satelliteId;
            }
            return this.advancedSatelliteIdArray[x];
        }
        return closestIdFound;
    }

    protected int getNextConnectLiquidSatelliteId(boolean prev, int x) {
        int closestIdFound = prev ? 0 : Integer.MAX_VALUE;
        for (BaseLogicLiquidSatellite satellite : BaseLogicLiquidSatellite.AllSatellites) {
            CoreRoutedPipe satPipe = satellite.getRoutedPipe();
            if (satPipe == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null || !satPipe.isLiquidPipe()) continue;
            IRouter satRouter = satPipe.getRouter();
            ExitRoute route = this.getRoutedPipe().getRouter().getDistanceTo(satRouter);
            if (route == null) continue;
            if (x == -1) {
                if (!prev && satellite.satelliteId > this.liquidSatelliteId && satellite.satelliteId < closestIdFound) {
                    closestIdFound = satellite.satelliteId;
                    continue;
                }
                if (!prev || satellite.satelliteId >= this.liquidSatelliteId || satellite.satelliteId <= closestIdFound) continue;
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev && satellite.satelliteId > this.liquidSatelliteIdArray[x] && satellite.satelliteId < closestIdFound) {
                closestIdFound = satellite.satelliteId;
                continue;
            }
            if (!prev || satellite.satelliteId >= this.liquidSatelliteIdArray[x] || satellite.satelliteId <= closestIdFound) continue;
            closestIdFound = satellite.satelliteId;
        }
        if (closestIdFound == Integer.MAX_VALUE) {
            if (x == -1) {
                return this.liquidSatelliteId;
            }
            return this.liquidSatelliteIdArray[x];
        }
        return closestIdFound;
    }

    public void setNextSatellite(EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = ((CPipeNextSatellite)PacketHandler.getPacket(CPipeNextSatellite.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToServer(packet);
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(false, -1);
            CoordinatesPacket packet = ((CPipeSatelliteId)PacketHandler.getPacket(CPipeSatelliteId.class)).setPipeId(this.satelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToPlayer(packet, (Player)player);
        }
    }

    public void setSatelliteId(int satelliteId, int x) {
        if (x == -1) {
            this.satelliteId = satelliteId;
        } else {
            this.advancedSatelliteIdArray[x] = satelliteId;
        }
    }

    public void setPrevSatellite(EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            CoordinatesPacket packet = ((CPipePrevSatellite)PacketHandler.getPacket(CPipePrevSatellite.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToServer(packet);
        } else {
            this.satelliteId = this.getNextConnectSatelliteId(true, -1);
            CoordinatesPacket packet = ((CPipeSatelliteId)PacketHandler.getPacket(CPipeSatelliteId.class)).setPipeId(this.satelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToPlayer(packet, (Player)player);
        }
    }

    public boolean isSatelliteConnected() {
        List routes = this.getRoutedPipe().getRouter().getIRoutersByCost();
        if (!((CoreRoutedPipe)this.container.pipe).getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (this.satelliteId == 0) {
                return true;
            }
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.satelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                IRouter satRouter = satPipe.getRouter();
                for (ExitRoute route : routes) {
                    if (route.destination != satRouter) continue;
                    return true;
                }
            }
        } else {
            boolean foundAll = true;
            for (int i = 0; i < 9; ++i) {
                boolean foundOne = false;
                if (this.advancedSatelliteIdArray[i] == 0) continue;
                block3: for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                    CoreRoutedPipe satPipe;
                    if (satellite.satelliteId != this.advancedSatelliteIdArray[i] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                    IRouter satRouter = satPipe.getRouter();
                    for (ExitRoute route : routes) {
                        if (route.destination != satRouter) continue;
                        foundOne = true;
                        continue block3;
                    }
                }
                foundAll &= foundOne;
            }
            return foundAll;
        }
        return false;
    }

    public IRouter getSatelliteRouter(int x) {
        if (x == -1) {
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.satelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        } else {
            for (BaseLogicSatellite satellite : BaseLogicSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.advancedSatelliteIdArray[x] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        this._dummyInventory.readFromNBT(nbttagcompound, "");
        this._liquidInventory.readFromNBT(nbttagcompound, "LiquidInv");
        this.satelliteId = nbttagcompound.func_74762_e("satelliteid");
        this.priority = nbttagcompound.func_74762_e("priority");
        for (i = 0; i < 9; ++i) {
            this.advancedSatelliteIdArray[i] = nbttagcompound.func_74762_e("advancedSatelliteId" + i);
        }
        for (i = 0; i < 6; ++i) {
            this.craftingSigns[i] = nbttagcompound.func_74767_n("craftingSigns" + i);
        }
        if (nbttagcompound.func_74764_b("LiquidAmount")) {
            this.amount = nbttagcompound.func_74759_k("LiquidAmount");
        }
        if (this.amount.length < 3) {
            this.amount = new int[3];
        }
        for (i = 0; i < 3; ++i) {
            this.liquidSatelliteIdArray[i] = nbttagcompound.func_74762_e("liquidSatelliteIdArray" + i);
        }
        for (i = 0; i < 3; ++i) {
            this.liquidSatelliteIdArray[i] = nbttagcompound.func_74762_e("liquidSatelliteIdArray" + i);
        }
        this.liquidSatelliteId = nbttagcompound.func_74762_e("liquidSatelliteId");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        int i;
        super.writeToNBT(nbttagcompound);
        this._dummyInventory.writeToNBT(nbttagcompound, "");
        this._liquidInventory.writeToNBT(nbttagcompound, "LiquidInv");
        nbttagcompound.func_74768_a("satelliteid", this.satelliteId);
        nbttagcompound.func_74768_a("priority", this.priority);
        for (i = 0; i < 9; ++i) {
            nbttagcompound.func_74768_a("advancedSatelliteId" + i, this.advancedSatelliteIdArray[i]);
        }
        for (i = 0; i < 6; ++i) {
            nbttagcompound.func_74757_a("craftingSigns" + i, this.craftingSigns[i]);
        }
        for (i = 0; i < 3; ++i) {
            nbttagcompound.func_74768_a("liquidSatelliteIdArray" + i, this.liquidSatelliteIdArray[i]);
        }
        nbttagcompound.func_74783_a("LiquidAmount", this.amount);
        nbttagcompound.func_74768_a("liquidSatelliteId", this.liquidSatelliteId);
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        if (MainProxy.isServer(entityplayer.field_70170_p)) {
            MainProxy.sendPacketToPlayer(((GuiArgument)PacketHandler.getPacket(GuiArgument.class)).setGuiID(10).setArgs(new Object[]{((CoreRoutedPipe)this.container.pipe).getUpgradeManager().isAdvancedSatelliteCrafter(), ((CoreRoutedPipe)this.container.pipe).getUpgradeManager().getLiquidCrafter(), this.amount, ((CoreRoutedPipe)this.container.pipe).getUpgradeManager().hasByproductExtractor()}), (Player)entityplayer);
            entityplayer.openGui((Object)LogisticsPipes.instance, 10, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void throttledUpdateEntity() {
        super.throttledUpdateEntity();
        if (this._lostItems.isEmpty()) {
            return;
        }
        DelayedGeneric lostItem = (DelayedGeneric)this._lostItems.poll();
        while (lostItem != null) {
            SinkReply reply;
            ItemIdentifierStack stack = (ItemIdentifierStack)lostItem.get();
            if (!(this._pipe == null || this._pipe.hasOrder() || (reply = LogisticsManagerV2.canSink(this._pipe.getRouter(), null, true, stack.getItem(), null, true, true)) != null && reply.maxNumberOfItems >= 1)) {
                lostItem = (DelayedGeneric)this._lostItems.poll();
                continue;
            }
            int received = RequestTree.requestPartial(stack, (CoreRoutedPipe)this.container.pipe);
            if (received < stack.stackSize) {
                stack.stackSize -= received;
                this._lostItems.add(new DelayedGeneric(stack, 5000L));
            }
            lostItem = (DelayedGeneric)this._lostItems.poll();
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item) {
    }

    @Override
    public void itemLost(ItemIdentifierStack item) {
        this._lostItems.add(new DelayedGeneric(item, 5000L));
    }

    public void openAttachedGui(EntityPlayer player) {
        int i;
        if (MainProxy.isClient(player.field_70170_p)) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71053_j();
            } else if (player instanceof EntityPlayerSP) {
                ((EntityPlayerSP)player).func_71053_j();
            }
            MainProxy.sendPacketToServer(((CraftingPipeOpenConnectedGuiPacket)PacketHandler.getPacket(CraftingPipeOpenConnectedGuiPacket.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
            return;
        }
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        boolean found = false;
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            Block block;
            for (ICraftingRecipeProvider provider : SimpleServiceLocator.craftingRecipeProviders) {
                if (!provider.canOpenGui(tile.tile)) continue;
                found = true;
                break;
            }
            if (!found) {
                boolean bl = found = tile.tile instanceof IInventory && !(tile.tile instanceof TileGenericPipe);
            }
            if (!found || (block = this.worldObj.func_72798_a(tile.tile.field_70329_l, tile.tile.field_70330_m, tile.tile.field_70327_n) < Block.field_71973_m.length ? Block.field_71973_m[this.worldObj.func_72798_a(tile.tile.field_70329_l, tile.tile.field_70330_m, tile.tile.field_70327_n)] : null) == null || !block.func_71903_a(this.worldObj, tile.tile.field_70329_l, tile.tile.field_70330_m, tile.tile.field_70327_n, player, 0, 0.0f, 0.0f, 0.0f)) continue;
            break;
        }
        player.field_71071_by.field_70461_c = savedEquipped;
    }

    public void importFromCraftingTable(EntityPlayer player) {
        CoordinatesPacket packet;
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            ICraftingRecipeProvider provider;
            Iterator i$ = SimpleServiceLocator.craftingRecipeProviders.iterator();
            while (i$.hasNext() && !(provider = (ICraftingRecipeProvider)i$.next()).importRecipe(tile.tile, this._dummyInventory)) {
            }
        }
        if (player == null) {
            return;
        }
        if (MainProxy.isClient(player.field_70170_p)) {
            packet = ((CPipeSatelliteImport)PacketHandler.getPacket(CPipeSatelliteImport.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToServer(packet);
        } else {
            packet = ((CPipeSatelliteImportBack)PacketHandler.getPacket(CPipeSatelliteImportBack.class)).setInventory(this._dummyInventory).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord);
            MainProxy.sendPacketToPlayer(packet, (Player)player);
            MainProxy.sendPacketToAllWatchingChunk(this.xCoord, this.zCoord, MainProxy.getDimensionForWorld(this.worldObj), packet);
        }
    }

    public void handleStackMove(int number) {
        ItemStack stack;
        if (MainProxy.isClient(this.worldObj)) {
            MainProxy.sendPacketToServer(((CraftingPipeStackMovePacket)PacketHandler.getPacket(CraftingPipeStackMovePacket.class)).setInteger(number).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        }
        if ((stack = this._dummyInventory.func_70301_a(number)) == null) {
            return;
        }
        for (int i = 6; i < 9; ++i) {
            ItemStack stackb = this._dummyInventory.func_70301_a(i);
            if (stackb != null) continue;
            this._dummyInventory.func_70299_a(i, stack);
            this._dummyInventory.func_70299_a(number, null);
            break;
        }
    }

    public void priorityUp(EntityPlayer player) {
        ++this.priority;
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(((CraftingPipePriorityUpPacket)PacketHandler.getPacket(CraftingPipePriorityUpPacket.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        } else if (player != null && MainProxy.isServer(player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(((CraftingPriority)PacketHandler.getPacket(CraftingPriority.class)).setInteger(this.priority).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        }
    }

    public void priorityDown(EntityPlayer player) {
        --this.priority;
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(((CraftingPipePriorityDownPacket)PacketHandler.getPacket(CraftingPipePriorityDownPacket.class)).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        } else if (player != null && MainProxy.isServer(player.field_70170_p)) {
            MainProxy.sendPacketToPlayer(((CraftingPriority)PacketHandler.getPacket(CraftingPriority.class)).setInteger(this.priority).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        }
    }

    public void setPriority(int amount) {
        this.priority = amount;
    }

    public List getCraftedItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(1);
        if (this._dummyInventory.func_70301_a(9) != null) {
            list.add(this._dummyInventory.func_70301_a(9));
        }
        return list;
    }

    public ItemStack getByproductItem() {
        return this._dummyInventory.func_70301_a(10);
    }

    public ItemStack getMaterials(int slotnr) {
        return this._dummyInventory.func_70301_a(slotnr);
    }

    public LiquidIdentifier getLiquidMaterial(int slotnr) {
        ItemStack stack = this._liquidInventory.func_70301_a(slotnr);
        if (stack == null) {
            return null;
        }
        return ItemIdentifier.get(stack).getLiquidIdentifier();
    }

    public SimpleInventory getDummyInventory() {
        return this._dummyInventory;
    }

    public SimpleInventory getLiquidInventory() {
        return this._liquidInventory;
    }

    public void setDummyInventorySlot(int slot, ItemStack itemstack) {
        this._dummyInventory.func_70299_a(slot, itemstack);
    }

    public void setNextSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(((CraftingPipeNextAdvancedSatellitePacket)PacketHandler.getPacket(CraftingPipeNextAdvancedSatellitePacket.class)).setInteger(i).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(false, i);
            MainProxy.sendPacketToPlayer(((CraftingAdvancedSatelliteId)PacketHandler.getPacket(CraftingAdvancedSatelliteId.class)).setInteger2(i).setInteger(this.advancedSatelliteIdArray[i]).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        }
    }

    public void setPrevSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(((CraftingPipePrevAdvancedSatellitePacket)PacketHandler.getPacket(CraftingPipePrevAdvancedSatellitePacket.class)).setInteger(i).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        } else {
            this.advancedSatelliteIdArray[i] = this.getNextConnectSatelliteId(true, i);
            MainProxy.sendPacketToPlayer(((CraftingAdvancedSatelliteId)PacketHandler.getPacket(CraftingAdvancedSatelliteId.class)).setInteger2(i).setInteger(this.advancedSatelliteIdArray[i]).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        }
    }

    public void setParentPipe(PipeItemsCraftingLogistics pipeItemsCraftingLogistics) {
        this._pipe = pipeItemsCraftingLogistics;
    }

    public void changeLiquidAmount(int change, int slot, EntityPlayer player) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(((LiquidCraftingAmount)PacketHandler.getPacket(LiquidCraftingAmount.class)).setInteger2(slot).setInteger(change).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        } else {
            int n = slot;
            this.amount[n] = this.amount[n] + change;
            if (this.amount[slot] <= 0) {
                this.amount[slot] = 0;
            }
            MainProxy.sendPacketToPlayer(((LiquidCraftingAmount)PacketHandler.getPacket(LiquidCraftingAmount.class)).setInteger2(slot).setInteger(this.amount[slot]).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        }
    }

    public void setPrevLiquidSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(((LiquidCraftingPipeAdvancedSatellitePrevPacket)PacketHandler.getPacket(LiquidCraftingPipeAdvancedSatellitePrevPacket.class)).setInteger(i).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        } else if (i == -1) {
            this.liquidSatelliteId = this.getNextConnectLiquidSatelliteId(true, i);
            MainProxy.sendPacketToPlayer(((LiquidCraftingAdvancedSatelliteId)PacketHandler.getPacket(LiquidCraftingAdvancedSatelliteId.class)).setInteger2(i).setInteger(this.liquidSatelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        } else {
            this.liquidSatelliteIdArray[i] = this.getNextConnectLiquidSatelliteId(true, i);
            MainProxy.sendPacketToPlayer(((LiquidCraftingAdvancedSatelliteId)PacketHandler.getPacket(LiquidCraftingAdvancedSatelliteId.class)).setInteger2(i).setInteger(this.liquidSatelliteIdArray[i]).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        }
    }

    public void setNextLiquidSatellite(EntityPlayer player, int i) {
        if (MainProxy.isClient(player.field_70170_p)) {
            MainProxy.sendPacketToServer(((LiquidCraftingPipeAdvancedSatelliteNextPacket)PacketHandler.getPacket(LiquidCraftingPipeAdvancedSatelliteNextPacket.class)).setInteger(i).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord));
        } else if (i == -1) {
            this.liquidSatelliteId = this.getNextConnectLiquidSatelliteId(false, i);
            MainProxy.sendPacketToPlayer(((LiquidCraftingAdvancedSatelliteId)PacketHandler.getPacket(LiquidCraftingAdvancedSatelliteId.class)).setInteger2(i).setInteger(this.liquidSatelliteId).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        } else {
            this.liquidSatelliteIdArray[i] = this.getNextConnectLiquidSatelliteId(false, i);
            MainProxy.sendPacketToPlayer(((LiquidCraftingAdvancedSatelliteId)PacketHandler.getPacket(LiquidCraftingAdvancedSatelliteId.class)).setInteger2(i).setInteger(this.liquidSatelliteIdArray[i]).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord), (Player)player);
        }
    }

    public void setLiquidAmount(int[] amount) {
        if (MainProxy.isClient(this.worldObj)) {
            this.amount = amount;
        }
    }

    public void defineLiquidAmount(int integer, int slot) {
        if (MainProxy.isClient(this.worldObj)) {
            this.amount[slot] = integer;
        }
    }

    public int[] getLiquidAmount() {
        return this.amount;
    }

    public void setLiquidSatelliteId(int integer, int slot) {
        if (slot == -1) {
            this.liquidSatelliteId = integer;
        } else {
            this.liquidSatelliteIdArray[slot] = integer;
        }
    }

    public IRouter getLiquidSatelliteRouter(int x) {
        if (x == -1) {
            for (BaseLogicLiquidSatellite satellite : BaseLogicLiquidSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.liquidSatelliteId || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        } else {
            for (BaseLogicLiquidSatellite satellite : BaseLogicLiquidSatellite.AllSatellites) {
                CoreRoutedPipe satPipe;
                if (satellite.satelliteId != this.liquidSatelliteIdArray[x] || (satPipe = satellite.getRoutedPipe()) == null || satPipe.stillNeedReplace() || satPipe.getRouter() == null) continue;
                return satPipe.getRouter();
            }
        }
        return null;
    }

    @Override
    public void destroy() {
    }
}

