/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.items.LogisticsItem;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CombinedSneakyUpgrade;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.LiquidCraftingUpgrade;
import logisticspipes.pipes.upgrades.SpeedUpgrade;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeDOWN;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeEAST;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeNORTH;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeSOUTH;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeUP;
import logisticspipes.pipes.upgrades.connection.ConnectionUpgradeWEST;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeDOWN;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeEAST;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeNORTH;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeSOUTH;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeUP;
import logisticspipes.pipes.upgrades.sneaky.SneakyUpgradeWEST;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemUpgrade
extends LogisticsItem {
    public static final int SNEAKY_UP = 0;
    public static final int SNEAKY_DOWN = 1;
    public static final int SNEAKY_NORTH = 2;
    public static final int SNEAKY_SOUTH = 3;
    public static final int SNEAKY_EAST = 4;
    public static final int SNEAKY_WEST = 5;
    public static final int SNEAKY_COMBINATION = 6;
    public static final int CONNECTION_UP = 10;
    public static final int CONNECTION_DOWN = 11;
    public static final int CONNECTION_NORTH = 12;
    public static final int CONNECTION_SOUTH = 13;
    public static final int CONNECTION_EAST = 14;
    public static final int CONNECTION_WEST = 15;
    public static final int SPEED = 20;
    public static final int ADVANCED_SAT_CRAFTINGPIPE = 21;
    public static final int LIQUID_CRAFTING = 22;
    public static final int CRAFTING_BYPRODUCT_EXTRACTOR = 23;
    public static final int MAX_LIQUID_CRAFTER = 3;
    List upgrades = new ArrayList();
    private static Icon[] icons;

    public ItemUpgrade(int i) {
        super(i);
        this.field_77787_bX = true;
    }

    public void loadUpgrades() {
        this.registerUpgrade(0, "Sneaky Upgrade (UP)", SneakyUpgradeUP.class, 0);
        this.registerUpgrade(1, "Sneaky Upgrade (DOWN)", SneakyUpgradeDOWN.class, 1);
        this.registerUpgrade(2, "Sneaky Upgrade (NORTH)", SneakyUpgradeNORTH.class, 2);
        this.registerUpgrade(3, "Sneaky Upgrade (SOUTH)", SneakyUpgradeSOUTH.class, 3);
        this.registerUpgrade(4, "Sneaky Upgrade (EAST)", SneakyUpgradeEAST.class, 4);
        this.registerUpgrade(5, "Sneaky Upgrade (WEST)", SneakyUpgradeWEST.class, 5);
        this.registerUpgrade(6, "Sneaky Combination Upgrade", CombinedSneakyUpgrade.class, 6);
        this.registerUpgrade(20, "Item Speed Upgrade", SpeedUpgrade.class, 7);
        this.registerUpgrade(10, "Disconnection Upgrade (UP)", ConnectionUpgradeUP.class, 8);
        this.registerUpgrade(11, "Disconnection Upgrade (DOWN)", ConnectionUpgradeDOWN.class, 9);
        this.registerUpgrade(12, "Disconnection Upgrade (NORTH)", ConnectionUpgradeNORTH.class, 10);
        this.registerUpgrade(13, "Disconnection Upgrade (SOUTH)", ConnectionUpgradeSOUTH.class, 11);
        this.registerUpgrade(14, "Disconnection Upgrade (EAST)", ConnectionUpgradeEAST.class, 12);
        this.registerUpgrade(15, "Disconnection Upgrade (WEST)", ConnectionUpgradeWEST.class, 13);
        this.registerUpgrade(21, "Advanced Satellite Upgrade", AdvancedSatelliteUpgrade.class, 14);
        this.registerUpgrade(22, "Liquid Crafting Upgrade", LiquidCraftingUpgrade.class, 15);
        this.registerUpgrade(23, "Crafting Byproduct Extraction Upgrade", CraftingByproductUpgrade.class, 16);
    }

    public void registerUpgrade(int id, String name, Class moduleClass) {
        boolean flag = true;
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != id) continue;
            flag = false;
        }
        if ("".equals(name) || !flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (Id " + id + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (No name given)");
        }
        this.upgrades.add(new Upgrade(id, name, moduleClass));
    }

    public void registerUpgrade(int id, String name, Class moduleClass, int textureId) {
        boolean flag = true;
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != id) continue;
            flag = false;
        }
        if ("".equals(name) || !flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (Id " + id + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Upgrade. (No name given)");
        }
        this.upgrades.add(new Upgrade(id, name, moduleClass, textureId));
    }

    public int[] getRegisteredUpgradeIDs() {
        int[] array = new int[this.upgrades.size()];
        int i = 0;
        for (Upgrade upgrade : this.upgrades) {
            array[i++] = upgrade.getId();
        }
        return array;
    }

    public CreativeTabs func_77640_w() {
        return CreativeTabs.field_78028_d;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Upgrade upgrade : this.upgrades) {
            par3List.add(new ItemStack((Item)this, 1, upgrade.getId()));
        }
    }

    public IPipeUpgrade getUpgradeForItem(ItemStack itemStack, IPipeUpgrade currentUpgrade) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.field_77993_c != this.field_77779_bT) {
            return null;
        }
        for (Upgrade upgrade : this.upgrades) {
            if (itemStack.func_77960_j() != upgrade.getId()) continue;
            if (upgrade.getIPipeUpgradeClass() == null) {
                return null;
            }
            if (currentUpgrade != null && upgrade.getIPipeUpgradeClass().equals(currentUpgrade.getClass())) {
                return currentUpgrade;
            }
            IPipeUpgrade newupgrade = upgrade.getIPipeUpgrade();
            if (newupgrade == null) {
                return null;
            }
            return newupgrade;
        }
        return null;
    }

    public String func_77628_j(ItemStack itemstack) {
        for (Upgrade upgrade : this.upgrades) {
            if (itemstack.func_77960_j() != upgrade.getId()) continue;
            return upgrade.getName();
        }
        return null;
    }

    @Override
    public void func_94581_a(IconRegister par1IconRegister) {
        icons = new Icon[18];
        ItemUpgrade.icons[0] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyUP");
        ItemUpgrade.icons[1] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyDOWN");
        ItemUpgrade.icons[2] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyNORTH");
        ItemUpgrade.icons[3] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakySOUTH");
        ItemUpgrade.icons[4] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyEAST");
        ItemUpgrade.icons[5] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyWEST");
        ItemUpgrade.icons[6] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/SneakyCombination");
        ItemUpgrade.icons[7] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/Speed");
        ItemUpgrade.icons[8] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/DisUP");
        ItemUpgrade.icons[9] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/DisDOWN");
        ItemUpgrade.icons[10] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/DisNORTH");
        ItemUpgrade.icons[11] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/DisSOUTH");
        ItemUpgrade.icons[12] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/DisEAST");
        ItemUpgrade.icons[13] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/DisWEST");
        ItemUpgrade.icons[14] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/Satelite");
        ItemUpgrade.icons[15] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/LiquidCrafting");
        ItemUpgrade.icons[16] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/CraftingByproduct");
        ItemUpgrade.icons[17] = par1IconRegister.func_94245_a("logisticspipes:itemUpgrade/UNKNOWN01");
    }

    public Icon func_77617_a(int i) {
        for (Upgrade upgrade : this.upgrades) {
            if (upgrade.getId() != i || upgrade.getTextureIndex() == -1) continue;
            return icons[upgrade.getTextureIndex()];
        }
        return icons[0];
    }

    private class Upgrade {
        private String name;
        private int id;
        private Class upgradeClass;
        private int textureIndex = -1;

        private Upgrade(int id, String name, Class moduleClass) {
            this.id = id;
            this.name = name;
            this.upgradeClass = moduleClass;
        }

        private Upgrade(int id, String name, Class moduleClass, int textureIndex) {
            this.id = id;
            this.name = name;
            this.upgradeClass = moduleClass;
            this.textureIndex = textureIndex;
        }

        private IPipeUpgrade getIPipeUpgrade() {
            if (this.upgradeClass == null) {
                return null;
            }
            try {
                return (IPipeUpgrade)this.upgradeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }

        private Class getIPipeUpgradeClass() {
            return this.upgradeClass;
        }

        private int getId() {
            return this.id;
        }

        private String getName() {
            return this.name;
        }

        private int getTextureIndex() {
            return this.textureIndex;
        }
    }
}

