/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.items.LogisticsItem;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.modules.LogisticsGuiModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleAdvancedExtractor;
import logisticspipes.modules.ModuleAdvancedExtractorMK2;
import logisticspipes.modules.ModuleAdvancedExtractorMK3;
import logisticspipes.modules.ModuleApiaristAnalyser;
import logisticspipes.modules.ModuleApiaristRefiller;
import logisticspipes.modules.ModuleApiaristSink;
import logisticspipes.modules.ModuleApiaristTerminus;
import logisticspipes.modules.ModuleElectricBuffer;
import logisticspipes.modules.ModuleElectricManager;
import logisticspipes.modules.ModuleExtractor;
import logisticspipes.modules.ModuleExtractorMk2;
import logisticspipes.modules.ModuleExtractorMk3;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.modules.ModuleModBasedItemSink;
import logisticspipes.modules.ModuleOreDictItemSink;
import logisticspipes.modules.ModulePassiveSupplier;
import logisticspipes.modules.ModulePolymorphicItemSink;
import logisticspipes.modules.ModuleProvider;
import logisticspipes.modules.ModuleProviderMk2;
import logisticspipes.modules.ModuleQuickSort;
import logisticspipes.modules.ModuleTerminus;
import logisticspipes.modules.ModuleThaumicAspectSink;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SimpleInventory;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemModule
extends LogisticsItem {
    public static final int BLANK = 0;
    public static final int ITEMSINK = 1;
    public static final int PASSIVE_SUPPLIER = 2;
    public static final int EXTRACTOR = 3;
    public static final int POLYMORPHIC_ITEMSINK = 4;
    public static final int QUICKSORT = 5;
    public static final int TERMINUS = 6;
    public static final int ADVANCED_EXTRACTOR = 7;
    public static final int BEEANALYZER = 8;
    public static final int BEESINK = 9;
    public static final int APIARISTREFILLER = 10;
    public static final int APIARISTTERMINUS = 11;
    public static final int MODBASEDITEMSINK = 12;
    public static final int OREDICTITEMSINK = 13;
    public static final int THAUMICASPECTSINK = 30;
    public static final int EXTRACTOR_MK2 = 103;
    public static final int ADVANCED_EXTRACTOR_MK2 = 107;
    public static final int EXTRACTOR_MK3 = 203;
    public static final int ADVANCED_EXTRACTOR_MK3 = 207;
    public static final int ELECTRICMANAGER = 300;
    public static final int ELECTRICBUFFER = 301;
    public static final int PROVIDER = 500;
    public static final int PROVIDER_MK2 = 501;
    private List modules = new ArrayList();

    public ItemModule(int i) {
        super(i);
        this.field_77787_bX = true;
    }

    public void loadModules() {
        this.registerModule(0, "Blank module", null);
        this.registerModule(1, "ItemSink module", ModuleItemSink.class);
        this.registerModule(2, "Passive Supplier module", ModulePassiveSupplier.class);
        this.registerModule(3, "Extractor module", ModuleExtractor.class);
        this.registerModule(4, "Polymorphic ItemSink module", ModulePolymorphicItemSink.class);
        this.registerModule(5, "QuickSort module", ModuleQuickSort.class);
        this.registerModule(6, "Terminus module", ModuleTerminus.class);
        this.registerModule(7, "Advanced Extractor module", ModuleAdvancedExtractor.class);
        this.registerModule(103, "Extractor MK2 module", ModuleExtractorMk2.class);
        this.registerModule(107, "Advanced Extractor MK2", ModuleAdvancedExtractorMK2.class);
        this.registerModule(203, "Extractor MK3 module", ModuleExtractorMk3.class);
        this.registerModule(207, "Advanced Extractor MK3", ModuleAdvancedExtractorMK3.class);
        this.registerModule(500, "Provider module", ModuleProvider.class);
        this.registerModule(501, "Provider module MK2", ModuleProviderMk2.class);
        this.registerModule(300, "Electric Manager module", ModuleElectricManager.class);
        this.registerModule(301, "Electric Buffer module", ModuleElectricBuffer.class);
        this.registerModule(8, "Bee Analyzer module", ModuleApiaristAnalyser.class);
        this.registerModule(9, "BeeSink module", ModuleApiaristSink.class);
        this.registerModule(10, "Apiary Refiller module", ModuleApiaristRefiller.class);
        this.registerModule(11, "Drone Terminus module", ModuleApiaristTerminus.class);
        this.registerModule(12, "Mod Based ItemSink module", ModuleModBasedItemSink.class);
        this.registerModule(13, "OreDict ItemSink module", ModuleOreDictItemSink.class);
        this.registerModule(30, "Thaumic AspectSink module", ModuleThaumicAspectSink.class);
    }

    public void registerModule(int id, String name, Class moduleClass) {
        boolean flag = true;
        for (Module module : this.modules) {
            if (module.getId() != id) continue;
            flag = false;
        }
        if ("".equals(name) || !flag) {
            if (!flag) {
                throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (Id " + id + " already in use)");
            }
            throw new UnsupportedOperationException("Someting went wrong while registering a new Logistics Pipe Module. (No name given)");
        }
        this.modules.add(new Module(id, name, moduleClass));
    }

    public int[] getRegisteredModulesIDs() {
        int[] array = new int[this.modules.size()];
        int i = 0;
        for (Module module : this.modules) {
            array[i++] = module.getId();
        }
        return array;
    }

    public CreativeTabs func_77640_w() {
        return CreativeTabs.field_78028_d;
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Module module : this.modules) {
            par3List.add(new ItemStack((Item)this, 1, module.getId()));
        }
    }

    private void openConfigGui(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World) {
        LogisticsModule module = this.getModuleForItem(par1ItemStack, null, null, null, null, null);
        if (module != null && module instanceof LogisticsGuiModule && par1ItemStack != null && par1ItemStack.field_77994_a > 0) {
            par2EntityPlayer.openGui((Object)LogisticsPipes.instance, -1, par3World, ((LogisticsGuiModule)module).getGuiHandlerID(), -1, par2EntityPlayer.field_71071_by.field_70461_c);
        }
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (MainProxy.isServer(par3EntityPlayer.field_70170_p)) {
            this.openConfigGui(par1ItemStack, par3EntityPlayer, par2World);
        }
        return super.func_77659_a(par1ItemStack, par2World, par3EntityPlayer);
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        if (MainProxy.isServer(par2EntityPlayer.field_70170_p)) {
            TileEntity tile = par3World.func_72796_p(par4, par5, par6);
            if (tile instanceof LogisticsTileGenericPipe) {
                return true;
            }
            this.openConfigGui(par1ItemStack, par2EntityPlayer, par3World);
        }
        return true;
    }

    public LogisticsModule getModuleForItem(ItemStack itemStack, LogisticsModule currentModule, IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider power) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.field_77993_c != this.field_77779_bT) {
            return null;
        }
        for (Module module : this.modules) {
            if (itemStack.func_77960_j() != module.getId()) continue;
            if (module.getILogisticsModuleClass() == null) {
                return null;
            }
            if (currentModule != null && module.getILogisticsModuleClass().equals(currentModule.getClass())) {
                return currentModule;
            }
            LogisticsModule newmodule = module.getILogisticsModule();
            if (newmodule == null) {
                return null;
            }
            newmodule.registerHandler(invProvider, itemSender, world, power);
            return newmodule;
        }
        return null;
    }

    public String func_77628_j(ItemStack itemstack) {
        for (Module module : this.modules) {
            if (itemstack.func_77960_j() != module.getId()) continue;
            return module.getName();
        }
        return null;
    }

    @Override
    public void func_94581_a(IconRegister par1IconRegister) {
        if (this.modules.size() <= 0) {
            return;
        }
        for (Module module : this.modules) {
            module.registerModuleIcon(par1IconRegister);
        }
    }

    public Icon func_77617_a(int i) {
        for (Module module : this.modules) {
            if (module.getId() != i || module.getIcon() == null) continue;
            return module.getIcon();
        }
        return null;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean flag) {
        NBTTagCompound nbt;
        if (itemStack.func_77942_o() && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && (nbt = itemStack.func_77978_p()).func_74764_b("informationList")) {
            NBTTagList nbttaglist = nbt.func_74761_m("informationList");
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTBase nbttag = nbttaglist.func_74743_b(i);
                String data = ((NBTTagString)nbttag).field_74751_a;
                if (data.equals("<inventory>") && i + 1 < nbttaglist.func_74745_c()) {
                    nbttag = nbttaglist.func_74743_b(i + 1);
                    data = ((NBTTagString)nbttag).field_74751_a;
                    if (data.startsWith("<that>")) {
                        String prefix = data.substring(6);
                        NBTTagCompound module = nbt.func_74775_l("moduleInformation");
                        int size = module.func_74761_m(prefix + "items").func_74745_c();
                        if (module.func_74764_b(prefix + "itemsCount")) {
                            size = module.func_74762_e(prefix + "itemsCount");
                        }
                        SimpleInventory inv = new SimpleInventory(size, "InformationTempInventory", Integer.MAX_VALUE);
                        inv.readFromNBT(module, prefix);
                        for (int pos = 0; pos < inv.func_70302_i_(); ++pos) {
                            ItemStack stack = inv.func_70301_a(pos);
                            if (stack == null) continue;
                            if (stack.field_77994_a > 1) {
                                list.add("  " + stack.field_77994_a + "x " + ItemIdentifier.get(stack).getFriendlyName());
                                continue;
                            }
                            list.add("  " + ItemIdentifier.get(stack).getFriendlyName());
                        }
                    }
                    ++i;
                    continue;
                }
                list.add(data);
            }
        }
    }

    private class Module {
        private String name;
        private int id;
        private Class moduleClass;
        private Icon moduleIcon = null;

        private Module(int id, String name, Class moduleClass) {
            this.id = id;
            this.name = name;
            this.moduleClass = moduleClass;
        }

        private Module(int id, String name, Class moduleClass, Icon textureIndex) {
            this.id = id;
            this.name = name;
            this.moduleClass = moduleClass;
            this.moduleIcon = textureIndex;
        }

        private LogisticsModule getILogisticsModule() {
            if (this.moduleClass == null) {
                return null;
            }
            try {
                return (LogisticsModule)this.moduleClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return null;
        }

        private Class getILogisticsModuleClass() {
            return this.moduleClass;
        }

        private int getId() {
            return this.id;
        }

        private String getName() {
            return this.name;
        }

        private Icon getIcon() {
            return this.moduleIcon;
        }

        private void registerModuleIcon(IconRegister par1IconRegister) {
            if (this.moduleClass == null) {
                this.moduleIcon = par1IconRegister.func_94245_a("logisticspipes:" + ItemModule.this.func_77658_a().replace("item.", "") + "/blank");
            } else {
                try {
                    LogisticsModule instance = (LogisticsModule)this.moduleClass.newInstance();
                    this.moduleIcon = instance.getIconTexture(par1IconRegister);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

